/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import java.util.Map;
import org.jboss.tools.openshift.common.core.connection.AbstractConnectionPersistency;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionFactory;
import org.jboss.tools.openshift.core.preferences.IOpenShiftCorePreferences;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class ConnectionPersistency
extends AbstractConnectionPersistency<Connection> {
    private final IOpenShiftCorePreferences preferences;

    public ConnectionPersistency() {
        this(OpenShiftCorePreferences.INSTANCE);
    }

    protected ConnectionPersistency(IOpenShiftCorePreferences preferences) {
        this.preferences = preferences;
    }

    protected String[] loadPersisted() {
        return this.preferences.loadConnections();
    }

    protected void persist(Map<String, Connection> connections) {
        this.preferences.saveConnections(connections.keySet().toArray(new String[0]));
        for (Map.Entry<String, Connection> entry : connections.entrySet()) {
            this.preferences.saveExtProperties(entry.getKey(), entry.getValue().getExtendedProperties());
        }
    }

    protected void logError(String message, Exception e) {
        OpenShiftCoreActivator.pluginLog().logError(message, (Throwable)e);
    }

    protected Connection createConnection(ConnectionURL connectionURL) {
        Connection connection = new ConnectionFactory().create(connectionURL.getHostWithScheme());
        if (connection == null) {
            return null;
        }
        connection.setUsername(connectionURL.getUsername());
        connection.setAuthScheme(this.preferences.loadScheme(connectionURL.toString()));
        connection.setExtendedProperties(this.preferences.loadExtProperties(connectionURL.toString()));
        return connection;
    }
}

