/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.registry.IConnectionRegistryProvider;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class RegistryProviderModel {
    private static RegistryProviderModel model = new RegistryProviderModel();
    private ProviderPair[] registryProviders = null;

    public static RegistryProviderModel getDefault() {
        return model;
    }

    public IStatus getRegistryURL(IConnection c) {
        MultiStatus ms = new MultiStatus("org.jboss.tools.openshift.core", 0, "Unable to discover a registry URL for connection " + c.toString(), null);
        IConnectionRegistryProvider[] sorted = this.getProviders();
        int i = 0;
        while (i < sorted.length) {
            IStatus ret = sorted[i].getRegistryURL(c);
            if (ret != null) {
                if (ret.isOK()) {
                    return ret;
                }
                ms.add(ret);
            }
            ++i;
        }
        return ms;
    }

    private synchronized IConnectionRegistryProvider[] getProviders() {
        if (this.registryProviders == null) {
            this.loadProviders();
        }
        ArrayList<ProviderPair> l = new ArrayList<ProviderPair>(Arrays.asList(this.registryProviders));
        Comparator c = (e1, e2) -> e2.getWeight() - e1.getWeight();
        List<IConnectionRegistryProvider> ret = l.stream().sorted(c).map(ProviderPair::getProvider).collect(Collectors.toList());
        return ret.toArray(new IConnectionRegistryProvider[ret.size()]);
    }

    private void loadProviders() {
        ArrayList<ProviderPair> ret = new ArrayList<ProviderPair>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.tools.openshift.core.connection", "registryprovider");
        int i = 0;
        while (i < cf.length) {
            try {
                IConnectionRegistryProvider p = (IConnectionRegistryProvider)cf[i].createExecutableExtension("class");
                String weight = cf[i].getAttribute("weight");
                Integer in = Integer.parseInt(weight);
                if (p != null && in != null) {
                    ret.add(new ProviderPair(p, in));
                }
            }
            catch (CoreException e) {
                OpenShiftCoreActivator.pluginLog().logError("Failure loading registry provider extension", (Throwable)e);
            }
            ++i;
        }
        this.registryProviders = ret.toArray(new ProviderPair[ret.size()]);
    }

    private static class ProviderPair {
        IConnectionRegistryProvider element;
        int weight;

        public ProviderPair(IConnectionRegistryProvider el, int weight) {
            this.element = el;
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        public IConnectionRegistryProvider getProvider() {
            return this.element;
        }
    }
}

