/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.preferences;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.core.preferences.IOpenShiftCoreConstants;
import org.jboss.tools.openshift.core.preferences.IOpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.core.preferences.StringPreferenceValue;
import org.jboss.tools.openshift.internal.common.core.preferences.StringsPreferenceValue;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenShiftCorePreferences
implements IOpenShiftCoreConstants,
IOpenShiftCorePreferences {
    public static final OpenShiftCorePreferences INSTANCE = new OpenShiftCorePreferences();
    private static final String CONNECTIONS = "org.jboss.tools.openshift.core.connection.CONNECTION_NAMES";
    private static final String CONNECTION_AUTH_PREFIX = "org.jboss.tools.openshift.core.connection.auth";
    private static final String CONNECTION_EXT_PROPERTY_PREFIX = "org.jboss.tools.openshift.core.connection.extproperties";
    private final StringsPreferenceValue connectionsPreferenceValue = new StringsPreferenceValue('|', "org.jboss.tools.openshift.core.connection.CONNECTION_NAMES", "org.jboss.tools.openshift.core");
    private final StringPreferenceValue ocBinaryLocation = new StringPreferenceValue("openshift.cli.location", "org.jboss.tools.openshift.core");

    private OpenShiftCorePreferences() {
    }

    @Override
    public String[] loadConnections() {
        return this.connectionsPreferenceValue.get();
    }

    @Override
    public void saveConnections(String[] connections) {
        this.connectionsPreferenceValue.set(connections);
    }

    @Override
    public void saveAuthScheme(String connectionURL, String scheme) {
        this.createAuthSchemePreferenceValue(connectionURL).set(scheme);
    }

    @Override
    public void removeAuthScheme(String connectionURL) {
        this.createAuthSchemePreferenceValue(connectionURL).remove();
    }

    @Override
    public String loadScheme(String connectionURL) {
        return this.createAuthSchemePreferenceValue(connectionURL).get();
    }

    private StringPreferenceValue createAuthSchemePreferenceValue(String connectionURL) {
        return this.createPreferenceValue(CONNECTION_AUTH_PREFIX, connectionURL);
    }

    @Override
    public String getOCBinaryLocation() {
        return this.ocBinaryLocation.get();
    }

    @Override
    public void saveOCBinaryLocation(String location) {
        this.ocBinaryLocation.set(location);
    }

    @Override
    public void saveExtProperties(String connectionURL, Map<String, Object> ext) {
        if (connectionURL == null || ext == null) {
            return;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(ext);
            this.createPreferenceValue(CONNECTION_EXT_PROPERTY_PREFIX, connectionURL).set(json);
        }
        catch (IOException e) {
            OpenShiftCoreActivator.logError("Unable to persist ext properties for " + connectionURL, e);
        }
    }

    @Override
    public Map<String, Object> loadExtProperties(String connectionURL) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = this.createPreferenceValue(CONNECTION_EXT_PROPERTY_PREFIX, connectionURL).get();
            if (StringUtils.isNotBlank((String)json)) {
                return (Map)mapper.readValue((Reader)new StringReader(json), Map.class);
            }
        }
        catch (IOException e) {
            OpenShiftCoreActivator.logError("Unable to load ext properties for " + connectionURL, e);
        }
        return new HashMap<String, Object>();
    }

    private StringPreferenceValue createPreferenceValue(String prefix, String connectionURL) {
        return new StringPreferenceValue(NLS.bind((String)"{0}.{1}", (Object)prefix, (Object)connectionURL), "org.jboss.tools.openshift.core");
    }
}

