/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class DevmodeMetadata {
    private static final String DEFAULT_ENABLEMENT_KEY = "DEBUG";
    private static final String DEFAULT_ENABLEMENT_VALUE = "true";
    private static final String DEFAULT_PORT_KEY = "DEBUG_PORT";
    private static final String DEFAULT_PORT_VALUE = "8787";
    private static final Pattern REGEX_LABEL_DEVMODE = Pattern.compile("\\\"com\\.redhat\\.dev-mode\\\" ?\\: ?\\\"([^(:|\\\")]+)(:|\\\")([^\\\"]*)");
    private static final Pattern REGEX_LABEL_DEVMODE_PORT = Pattern.compile("\\\"com\\.redhat\\.dev-mode\\.port\\\" ?\\: ?\\\"([^(:|\\\")]+)(:|\\\")([^\\\"]*)");
    private String enablementKey;
    private String enablementValue;
    private String portKey;
    private String portValue;

    public DevmodeMetadata(String metadata) {
        this.parse(metadata);
    }

    public String getEnablementKey() {
        return this.enablementKey;
    }

    public String getEnablementValue() {
        return this.enablementValue;
    }

    public String getPortKey() {
        return this.portKey;
    }

    public String getPortValue() {
        return this.portValue;
    }

    private void parse(String metadata) {
        if (!StringUtils.isEmpty((String)metadata)) {
            this.parseEnablement(metadata);
            this.parsePort(metadata);
        }
    }

    private void parseEnablement(String metadata) {
        Matcher matcher = REGEX_LABEL_DEVMODE.matcher(metadata);
        if (matcher.find()) {
            this.enablementKey = matcher.group(1);
            this.enablementValue = matcher.group(3);
        } else {
            this.enablementKey = DEFAULT_ENABLEMENT_KEY;
            this.enablementValue = DEFAULT_ENABLEMENT_VALUE;
        }
    }

    private void parsePort(String metadata) {
        Matcher matcher = REGEX_LABEL_DEVMODE_PORT.matcher(metadata);
        if (matcher.find()) {
            this.portKey = matcher.group(1);
            this.portValue = matcher.group(3);
        } else {
            this.portKey = DEFAULT_PORT_KEY;
            this.portValue = DEFAULT_PORT_VALUE;
        }
    }
}

