/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.deploy.IDeploymentTrigger;
import com.openshift.restclient.model.image.IImageStreamImport;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.DevmodeMetadata;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.PodDeploymentPathMetadata;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class DockerImageLabels {
    private static final String SHARED_DATA_KEY = "DOCKER_IMAGE_LABELS";
    private IResource resource;
    private Connection connection;
    private String metadata;
    private DevmodeMetadata devmodeMetadata;
    private PodDeploymentPathMetadata podPathMetadata;

    public static DockerImageLabels getInstance(IResource resource, IControllableServerBehavior behaviour) {
        DockerImageLabels metadata = (DockerImageLabels)behaviour.getSharedData(SHARED_DATA_KEY);
        if (metadata == null || !Objects.equals(resource, metadata.resource)) {
            Connection connection = OpenShiftServerUtils.getConnection((IServerAttributes)behaviour.getServer());
            metadata = new DockerImageLabels(resource, connection);
            behaviour.putSharedData(SHARED_DATA_KEY, (Object)metadata);
        }
        return metadata;
    }

    protected DockerImageLabels(IResource resource, Connection connection) {
        this.resource = resource;
        this.connection = connection;
    }

    public String getDevmodeKey() {
        if (!this.loadIfRequired()) {
            return null;
        }
        return this.devmodeMetadata.getEnablementKey();
    }

    public String getDevmodePortKey() {
        if (!this.loadIfRequired()) {
            return null;
        }
        return this.devmodeMetadata.getPortKey();
    }

    public String getDevmodePortValue() {
        if (!this.loadIfRequired()) {
            return null;
        }
        return this.devmodeMetadata.getPortValue();
    }

    public String getPodPath() {
        if (!this.loadIfRequired()) {
            return null;
        }
        return this.podPathMetadata.get();
    }

    public boolean load() {
        return this.loadIfRequired();
    }

    private boolean isLoaded() {
        return this.metadata != null;
    }

    protected boolean loadIfRequired() {
        if (this.isLoaded()) {
            return true;
        }
        this.metadata = this.load(this.resource);
        if (StringUtils.isEmpty((String)this.metadata)) {
            return false;
        }
        this.devmodeMetadata = new DevmodeMetadata(this.metadata);
        this.podPathMetadata = new PodDeploymentPathMetadata(this.metadata);
        return true;
    }

    public boolean isAvailable() {
        return this.isLoaded();
    }

    protected String load(IResource resource) {
        IDeploymentConfig dc = ResourceUtils.getDeploymentConfigFor(resource, this.connection);
        if (dc == null) {
            return null;
        }
        IDeploymentImageChangeTrigger trigger = this.getImageChangeTrigger(dc.getTriggers());
        if (trigger == null) {
            return null;
        }
        DockerImageURI uri = trigger.getFrom();
        return this.getImageStreamTag(uri, resource.getNamespace());
    }

    private IDeploymentImageChangeTrigger getImageChangeTrigger(Collection<IDeploymentTrigger> triggers) {
        for (IDeploymentTrigger trigger : triggers) {
            if (!"ImageChange".equals(trigger.getType())) continue;
            return (IDeploymentImageChangeTrigger)trigger;
        }
        return null;
    }

    private String getImageStreamTag(DockerImageURI uri, String namespace) {
        try {
            Object imageStreamTag = this.connection.getResource("ImageStreamTag", namespace, uri.getAbsoluteUri());
            return imageStreamTag.toJson();
        }
        catch (OpenShiftException openShiftException) {
            return null;
        }
    }

    private String getImageRef(IDeploymentConfig dc, Connection connection) throws CoreException {
        Collection images = dc.getImages();
        if (images.isEmpty()) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"No images found for deployment config {0} in project {1} on server {2}", (Object[])new Object[]{dc.getName(), dc.getNamespace(), connection.getHost()})));
        }
        return (String)images.iterator().next();
    }

    private String getImageStreamTag(String imageDigest, String imageRef, String namespace, Connection connection) {
        List imageStreamTags = connection.getResources("ImageStreamTag", namespace);
        Object imageStreamTag = ResourceUtils.getImageStreamTagForDigest(imageDigest, imageStreamTags);
        if (imageStreamTag == null) {
            return null;
        }
        imageStreamTag = connection.getResource("ImageStreamTag", namespace, imageStreamTag.getName());
        return imageStreamTag.toJson();
    }

    private String importImageStream(String imageRef, IProject project) {
        DockerImageURI uri;
        IImageStreamImportCapability imageStreamImportCapability = (IImageStreamImportCapability)project.getCapability(IImageStreamImportCapability.class);
        IImageStreamImport imageStreamImport = imageStreamImportCapability.importImageMetadata(uri = new DockerImageURI(imageRef));
        if (!ResourceUtils.isSuccessful(imageStreamImport)) {
            return null;
        }
        return imageStreamImport.getImageJsonFor(uri);
    }
}

