/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.CachedPublisherProfileBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenShiftServerBehaviour
extends CachedPublisherProfileBehavior {
    public static final String PROFILE_OPENSHIFT3 = "openshift3";
    private static final String CURRENTLY_RESTARTING = "openshift.server.restarting";

    public void setServerStarted() {
        super.setServerStarted();
        this.launchPostStartupJobs();
    }

    public void restart(String launchMode) throws CoreException {
        this.setRestarting(true);
        super.restart(launchMode);
    }

    public boolean isRestarting() {
        return Boolean.TRUE.equals(this.getSharedData(CURRENTLY_RESTARTING));
    }

    public void setRestarting(boolean restarting) {
        this.putSharedData(CURRENTLY_RESTARTING, restarting);
    }

    protected void launchPostStartupJobs() {
        try {
            IServer s = this.getServer();
            IModuleStateController modules = this.getModuleStateController();
            UpdateModuleStateJob moduleStateJob = null;
            if (modules != null) {
                moduleStateJob = new UpdateModuleStateJob(modules, s, true, 10000);
                moduleStateJob.schedule();
            }
        }
        catch (CoreException ce) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)ce);
        }
    }
}

