/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.core.IRouteChooser;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class OpenShiftServerExtendedProperties
extends ServerExtendedProperties {
    public OpenShiftServerExtendedProperties(IAdaptable adaptable) {
        super(adaptable);
    }

    public boolean allowConvenienceEnhancements() {
        return false;
    }

    public boolean hasWelcomePage() {
        return true;
    }

    public String getWelcomePageUrl() throws ServerExtendedProperties.GetWelcomePageURLException {
        String welcomePageUrl = null;
        try {
            Connection connection = OpenShiftServerUtils.getConnection((IServerAttributes)this.server);
            if (connection == null || !connection.connect()) {
                throw new ServerExtendedProperties.GetWelcomePageURLException("Connection is not established.");
            }
            IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)this.server, connection, (IProgressMonitor)new NullProgressMonitor());
            if (resource == null) {
                throw new ServerExtendedProperties.GetWelcomePageURLException("Resource is missing.");
            }
            IProject project = resource.getProject();
            if (project != null && resource instanceof IService) {
                List<IRoute> routes = ResourceUtils.getRoutesFor((IService)resource, project.getResources("Route"));
                IRoute route = this.getRoute(OpenShiftServerUtils.getRouteURL((IServerAttributes)this.server), routes);
                if (route == null) {
                    route = this.getRoute(routes);
                }
                if (route != null) {
                    welcomePageUrl = route.getURL();
                }
            }
        }
        catch (OpenShiftException e) {
            throw new ServerExtendedProperties.GetWelcomePageURLException(e.getMessage(), (Throwable)e);
        }
        return welcomePageUrl;
    }

    private IRoute getRoute(String url, List<IRoute> routes) {
        if (!StringUtils.isEmpty((String)url)) {
            for (IRoute route : routes) {
                if (!url.equals(route.getURL())) continue;
                return route;
            }
        }
        return null;
    }

    private IRoute getRoute(List<IRoute> routes) {
        IRouteChooser chooser = OpenShiftCoreUIIntegration.getInstance().getRouteChooser();
        IRoute route = null;
        if (routes == null || routes.isEmpty()) {
            chooser.noRouteErrorDialog();
            return null;
        }
        if (routes.size() > 1) {
            route = chooser.chooseRoute(routes);
            if (route != null && chooser.isRememberChoice()) {
                this.fireUpdateRoute((IServerAttributes)this.server, route.getURL());
            }
        } else {
            route = routes.get(0);
        }
        return route;
    }

    private void fireUpdateRoute(final IServerAttributes server, final String route) {
        new Job("Updating Route"){

            protected IStatus run(IProgressMonitor monitor) {
                IServerWorkingCopy wc = server.createWorkingCopy();
                wc.setAttribute("org.jboss.tools.openshift.Route", route);
                wc.setHost(UrlUtils.getHost((String)route));
                try {
                    wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

