/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jst.j2ee.internal.deployables.BinaryFileModuleDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.server.ServerUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.DockerImageLabels;
import org.jboss.tools.openshift.core.server.OpenShiftServerBehaviour;
import org.jboss.tools.openshift.core.server.RSync;
import org.jboss.tools.openshift.core.util.OpenShiftResourceUniqueId;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.WatchManager;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.osgi.service.prefs.BackingStoreException;

public class OpenShiftServerUtils {
    private static final String LIVERELOAD_PORT_KEY = "port";
    public static final String SERVER_PROJECT_QUALIFIER = "org.jboss.tools.openshift.core";
    public static final String ATTR_SERVICE = "org.jboss.tools.openshift.Service";
    public static final String ATTR_DEPLOYPROJECT = "org.jboss.tools.openshift.DeployProject";
    public static final String ATTR_SOURCE_PATH = "org.jboss.tools.openshift.SourcePath";
    public static final String ATTR_POD_PATH = "org.jboss.tools.openshift.PodPath";
    public static final String ATTR_ROUTE = "org.jboss.tools.openshift.Route";
    public static final String ATTR_DEVMODE_KEY = "org.jboss.tools.openshift.DevmodeKey";
    public static final String ATTR_DEBUG_PORT_KEY = "org.jboss.tools.openshift.DebugPortKey";
    public static final String ATTR_DEBUG_PORT_VALUE = "org.jboss.tools.openshift.DebugPortValue";
    public static final String ATTR_DEBUG_ROUTE_TIMEOUT = "org.jboss.tools.openshift.debug.RouteTimeout";
    public static final String ATTR_DEBUG_LIVENESSPROBE_INITIALDELAY = "org.jboss.tools.openshift.debug.livenessProbe.InitialDelay";
    public static final int VALUE_LIVENESSPROBE_NODELAY = -1;
    public static final String ATTR_IGNORE_CONTEXT_ROOT = "org.jboss.tools.openshift.IgnoreContextRoot";
    public static final String ATTR_OVERRIDE_PROJECT_SETTINGS = "org.jboss.tools.openshift.project.Override";
    public static final String ATTR_CONNECTIONURL = "org.jboss.tools.openshift.Connection";
    public static final String OPENSHIFT_SERVER_TYPE = "org.jboss.tools.openshift.openshift.server.type";
    public static final String SERVER_START_ON_CREATION = "org.jboss.tools.openshift.SERVER_START_ON_CREATION";
    private static final Collection<String> SERVER_ADAPTER_ALLOWED_RESOURCE_TYPES = Collections.unmodifiableCollection(Arrays.asList("Route", "Service", "ReplicationController", "DeploymentConfig", "Pod"));

    public static boolean isAllowedForServerAdapter(IResource resource) {
        return SERVER_ADAPTER_ALLOWED_RESOURCE_TYPES.contains(resource.getKind());
    }

    public static IServer findServerForResource(String serviceName) {
        return OpenShiftServerUtils.findServerForResource(serviceName, ServerCore.getServers());
    }

    public static IServer findServerForResource(String serviceName, IServer[] servers) {
        if (StringUtils.isEmpty((String)serviceName) || servers == null || servers.length == 0) {
            return null;
        }
        IServerType serverType = OpenShiftServerUtils.getServerType();
        if (serverType == null) {
            return null;
        }
        return Stream.of(servers).filter(server -> serverType.equals(server.getServerType()) && server.getAttribute(ATTR_SERVICE, "").equals(serviceName)).findFirst().orElse(null);
    }

    public static IServerType getServerType() {
        return ServerCore.findServerType((String)"org.jboss.tools.openshift.server.type");
    }

    public static String getServerName(IResource resource, IConnection connection) {
        if (resource == null) {
            return null;
        }
        String baseName = resource.getName() + " (" + resource.getKind() + ") at OpenShift 3 (" + UrlUtils.cutPort((String)UrlUtils.cutScheme((String)connection.getHost())) + ")";
        return ServerUtils.getServerName((String)baseName);
    }

    public static void updateServer(String serverName, String host, String connectionUrl, IResource resource, String sourcePath, String podPath, IProject deployProject, String routeURL, String devmodeKey, String debugPortKey, String debugPortValue, IServerWorkingCopy server) {
        String deployProjectName = ProjectUtils.getName((IProject)deployProject);
        OpenShiftServerUtils.updateServer(serverName, host, connectionUrl, deployProjectName, OpenShiftResourceUniqueId.get(resource), sourcePath, podPath, routeURL, devmodeKey, debugPortKey, debugPortValue, server);
    }

    public static void updateServer(String serverName, String host, String connectionUrl, String deployProjectName, String serviceId, String sourcePath, String podPath, String routeURL, String devmodeKey, String debugPortKey, String debugPortValue, IServerWorkingCopy server) {
        OpenShiftServerUtils.updateServer(server);
        server.setName(serverName);
        server.setHost(host);
        server.setAttribute(ATTR_CONNECTIONURL, connectionUrl);
        server.setAttribute(ATTR_DEPLOYPROJECT, deployProjectName);
        server.setAttribute(ATTR_SOURCE_PATH, sourcePath);
        server.setAttribute(ATTR_POD_PATH, podPath);
        server.setAttribute(ATTR_SERVICE, serviceId);
        server.setAttribute(ATTR_ROUTE, routeURL);
        server.setAttribute(ATTR_DEVMODE_KEY, devmodeKey);
        server.setAttribute(ATTR_DEBUG_PORT_KEY, debugPortKey);
        server.setAttribute(ATTR_DEBUG_PORT_VALUE, debugPortValue);
    }

    public static void updateServerAttribute(String attribute, String value, IServerAttributes server) throws CoreException {
        OpenShiftServerUtils.updateServerAttribute(attribute, value, server.createWorkingCopy());
    }

    public static void updateServerAttribute(String attribute, String value, IServerWorkingCopy server) throws CoreException {
        if (StringUtils.isEmpty((String)attribute)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Could not update server {0}, attribute name is missing.", (Object)server.getName())));
        }
        server.setAttribute(attribute, value);
        server.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void updateServer(IServerWorkingCopy server) {
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift3");
        ((ServerWorkingCopy)server).setAutoPublishSetting(2);
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", String.valueOf(Boolean.TRUE));
        int webPort = 80;
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.webPort", webPort);
        server.setAttribute(LIVERELOAD_PORT_KEY, webPort);
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", Boolean.FALSE.toString());
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", true);
    }

    public static void updateServerProject(String connectionUrl, IResource resource, String sourcePath, String podPath, String routeURL, String devmodeKey, String debugPortKey, String debugPortValue, IProject project) {
        OpenShiftServerUtils.updateServerProject(connectionUrl, OpenShiftResourceUniqueId.get(resource), sourcePath, podPath, routeURL, devmodeKey, debugPortKey, debugPortValue, project);
    }

    public static void updateServerProject(String connectionUrl, String serviceId, String sourcePath, String podPath, String routeURL, String devmodeKey, String debugPortKey, String debugPortValue, IProject project) {
        IEclipsePreferences node = ServerUtils.getProjectNode((String)SERVER_PROJECT_QUALIFIER, (IProject)project);
        node.put(ATTR_CONNECTIONURL, connectionUrl);
        node.put(ATTR_DEPLOYPROJECT, project.getName());
        node.put(ATTR_SOURCE_PATH, sourcePath);
        node.put(ATTR_SERVICE, serviceId);
        OpenShiftServerUtils.updateProjectNode(ATTR_POD_PATH, podPath, node);
        OpenShiftServerUtils.updateProjectNode(ATTR_ROUTE, routeURL, node);
        OpenShiftServerUtils.updateProjectNode(ATTR_DEVMODE_KEY, devmodeKey, node);
        OpenShiftServerUtils.updateProjectNode(ATTR_DEBUG_PORT_KEY, debugPortKey, node);
        OpenShiftServerUtils.updateProjectNode(ATTR_DEBUG_PORT_VALUE, debugPortValue, node);
        OpenShiftServerUtils.saveProject(node);
    }

    private static void updateProjectNode(String attribute, String value, IEclipsePreferences node) {
        if (value != null) {
            node.put(attribute, value);
        } else {
            node.remove(attribute);
        }
    }

    public static void updateServerProject(String attribute, String value, IProject project) throws CoreException {
        if (!StringUtils.isEmpty((String)attribute)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus("Could not update server project, setting name missing."));
        }
        if (!StringUtils.isEmpty((String)value)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Could not update server project, value for setting {0} is missing.", (Object)attribute)));
        }
        IEclipsePreferences node = ServerUtils.getProjectNode((String)SERVER_PROJECT_QUALIFIER, (IProject)project);
        node.put(attribute, value);
        OpenShiftServerUtils.saveProject(node);
    }

    private static void saveProject(IEclipsePreferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    public static IModule findProjectModule(IProject p) {
        IModule[] all = ServerUtil.getModules((IProject)p);
        int i = 0;
        while (i < all.length) {
            ModuleDelegate md = (ModuleDelegate)all[i].loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (md instanceof ProjectModule && !(md instanceof BinaryFileModuleDelegate)) {
                return all[i];
            }
            ++i;
        }
        return null;
    }

    public static IProject getDeployProject(IServerAttributes server) {
        return ProjectUtils.getProject((String)OpenShiftServerUtils.getDeployProjectName(server));
    }

    public static IProject checkedGetDeployProject(IServerAttributes server) throws CoreException {
        OpenShiftServerUtils.assertLegal(server != null, "Could not determine what server to get the deploy project for.");
        IProject project = OpenShiftServerUtils.getDeployProject(server);
        if (!ProjectUtils.isAccessible((IProject)project)) {
            throw new CoreException((IStatus)new Status(4, SERVER_PROJECT_QUALIFIER, NLS.bind((String)"Server adapter {0} cannot publish. Required project {1} is missing or inaccessible.", (Object)server.getName(), (Object)OpenShiftServerUtils.getDeployProjectName(server))));
        }
        return project;
    }

    public static String getDeployProjectName(IServerAttributes server) {
        if (server == null) {
            return null;
        }
        return server.getAttribute(ATTR_DEPLOYPROJECT, null);
    }

    public static boolean isIgnoresContextRoot(IServerAttributes server) {
        return server.getAttribute(ATTR_IGNORE_CONTEXT_ROOT, true);
    }

    public static boolean isOpenShiftRuntime(IServerAttributes server) {
        return OPENSHIFT_SERVER_TYPE.equals(server.getServerType().getId());
    }

    public static IServerWorkingCopy create(String name) throws CoreException {
        IServerWorkingCopy serverWorkingCopy = OpenShiftServerUtils.getServerType().createServer(name, null, null);
        return serverWorkingCopy;
    }

    public static Connection getConnectionChecked(IServerAttributes server) throws CoreException {
        Connection connection = OpenShiftServerUtils.getConnection(server);
        if (connection == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Could not find the connection for server {0}. Your server adapter might refer to an inexistant connection.", (Object)(server == null ? "" : server.getName()))));
        }
        return connection;
    }

    public static Connection getConnection(IServerAttributes server) {
        String url;
        Connection connection;
        block6: {
            if (server == null) {
                return null;
            }
            connection = null;
            url = OpenShiftServerUtils.getConnectionURL(server);
            if (!StringUtils.isEmpty((String)url)) break block6;
            return null;
        }
        try {
            ConnectionURL connectionUrl = ConnectionURL.forURL((String)url);
            if (connectionUrl != null) {
                connection = (Connection)ConnectionsRegistrySingleton.getInstance().getByUrl(connectionUrl, Connection.class);
            }
            if (connection == null) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not find an existing OpenShift connection to host {0} with user {1} for server {2}", (Object[])new String[]{connectionUrl.getHost(), connectionUrl.getUsername(), server.getName()}));
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Connection url stored in server {0} is malformed.", (Object)server.getName()), (Throwable)e);
        }
        return connection;
    }

    public static String getConnectionURL(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_CONNECTIONURL, server);
    }

    public static IResource getResource(IServerAttributes server, Connection connection, IProgressMonitor monitor) {
        String uniqueId = OpenShiftServerUtils.getAttribute(ATTR_SERVICE, server);
        if (StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        if (connection == null) {
            return null;
        }
        String projectName = OpenShiftResourceUniqueId.getProjectName(uniqueId);
        String kind = OpenShiftResourceUniqueId.getKind(uniqueId);
        List resources = connection.getResources(kind, projectName);
        Object resource = OpenShiftResourceUniqueId.getByUniqueId(uniqueId, resources);
        if (resource != null) {
            WatchManager.getInstance().startWatch(resource.getProject(), connection);
        }
        return resource;
    }

    public static IResource getResource(IServerAttributes attributes, IProgressMonitor monitor) {
        return OpenShiftServerUtils.getResource(attributes, OpenShiftServerUtils.getConnection(attributes), monitor);
    }

    public static IResource checkedGetResource(IServer server, IProgressMonitor monitor) throws CoreException {
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)server, monitor);
        if (resource == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the service to publish to.", (Object)server.getName())));
        }
        return resource;
    }

    public static IResource getResourceChecked(IServerAttributes server, Connection connection, IProgressMonitor monitor) throws CoreException {
        IResource resource = OpenShiftServerUtils.getResource(server, connection, monitor);
        if (resource == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Could not find the resource for server {0}. Your server adapter might refer to an inexistant resource.", (Object)(server == null ? "" : server.getName()))));
        }
        return resource;
    }

    public static String getRouteURL(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_ROUTE, server);
    }

    public static String getPodPath(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_POD_PATH, server);
    }

    public static String getDevmodeKey(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_DEVMODE_KEY, server);
    }

    public static String getDebugPortKey(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_DEBUG_PORT_KEY, server);
    }

    public static String getDebugPort(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_DEBUG_PORT_VALUE, server);
    }

    public static boolean hasRouteTimeout(IServerAttributes server) {
        return !StringUtils.isEmpty((String)OpenShiftServerUtils.getAttribute(ATTR_DEBUG_ROUTE_TIMEOUT, server));
    }

    public static String getRouteTimeout(IServerAttributes server) {
        return OpenShiftServerUtils.getAttribute(ATTR_DEBUG_ROUTE_TIMEOUT, server);
    }

    public static void setRouteTimeout(String timeout, IServerAttributes server) throws CoreException {
        OpenShiftServerUtils.updateServerAttribute(ATTR_DEBUG_ROUTE_TIMEOUT, timeout, server);
    }

    public static int getLivenessProbeInitialDelay(IServerAttributes server) {
        return NumberUtils.toInt((String)OpenShiftServerUtils.getAttribute(ATTR_DEBUG_LIVENESSPROBE_INITIALDELAY, server), (int)-1);
    }

    public static void setLivenessProbeInitialDelay(int delay, IServerAttributes server) throws CoreException {
        String stringDelay = null;
        stringDelay = delay == -1 ? null : String.valueOf(delay);
        OpenShiftServerUtils.updateServerAttribute(ATTR_DEBUG_LIVENESSPROBE_INITIALDELAY, stringDelay, server);
    }

    public static String loadPodPath(IResource resource, IServer server) {
        DockerImageLabels metaData = DockerImageLabels.getInstance(resource, OpenShiftServerUtils.getBehaviour(server));
        return metaData.getPodPath();
    }

    public static IControllableServerBehavior getBehaviour(IServer server) {
        return (IControllableServerBehavior)server.getAdapter(IControllableServerBehavior.class);
    }

    public static OpenShiftServerBehaviour getOpenShiftServerBehaviour(IServer server) throws CoreException {
        IControllableServerBehavior serverBehavior = OpenShiftServerUtils.getBehaviour(server);
        if (!(serverBehavior instanceof OpenShiftServerBehaviour)) {
            throw OpenShiftServerUtils.toCoreException("Unable to find a OpenShiftServerBehaviour instance");
        }
        return (OpenShiftServerBehaviour)serverBehavior;
    }

    public static OpenShiftServerBehaviour getOpenShiftServerBehaviour(ILaunchConfiguration configuration) throws CoreException {
        return OpenShiftServerUtils.getOpenShiftServerBehaviour(ServerUtil.getServer((ILaunchConfiguration)configuration));
    }

    public static RSync createRSync(IServer server, IProgressMonitor monitor) throws CoreException {
        IResource resource = OpenShiftServerUtils.checkedGetResource(server, monitor);
        String podPath = OpenShiftServerUtils.getOrLoadPodPath(server, resource);
        return OpenShiftServerUtils.createRSync(resource, podPath, server);
    }

    public static RSync createRSync(IResource resource, String podPath, IServer server) throws CoreException {
        OpenShiftServerUtils.assertLegal(resource != null, "Could not determine to what OpenShift resource to rsync to.");
        OpenShiftServerUtils.assertLegal(!StringUtils.isEmpty((String)podPath), "Could not determine to what pod destination path to rsync to");
        OpenShiftServerUtils.assertLegal(server != null, "Could not determine the server to use.");
        OpenShiftServerUtils.assertLegal(OCBinary.getInstance() != null && !StringUtils.isBlank((String)OCBinary.getInstance().getLocation(OpenShiftServerUtils.getConnection((IServerAttributes)server))), "Binary for oc-tools could not be found. Please open the OpenShift 3 Preference Page and set the location of the oc binary.");
        return new RSync(resource, podPath, server);
    }

    public static String getOrLoadPodPath(IServer server, IResource resource) throws CoreException {
        String podPath = OpenShiftServerUtils.getPodPath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)podPath) && StringUtils.isEmpty((String)(podPath = OpenShiftServerUtils.loadPodPath(resource, server)))) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the destination directory to publish to.", (Object)server.getName())));
        }
        return podPath;
    }

    public static String getSourcePath(IServerAttributes server) {
        String rawSourcePath = OpenShiftServerUtils.getAttribute(ATTR_SOURCE_PATH, server);
        if (StringUtils.isEmpty((String)rawSourcePath)) {
            return rawSourcePath;
        }
        return VariablesHelper.replaceVariables((String)rawSourcePath);
    }

    public static boolean isOverridesProject(IServerAttributes server) {
        return server.getAttribute(ATTR_OVERRIDE_PROJECT_SETTINGS, false);
    }

    private static String getProjectAttribute(String name, String defaultValue, IProject project) {
        return ServerUtils.getProjectAttribute((String)name, (String)defaultValue, (String)SERVER_PROJECT_QUALIFIER, (IProject)project);
    }

    protected static String getAttribute(String key, IServerAttributes server) {
        if (server == null) {
            return null;
        }
        String attribute = server.getAttribute(key, null);
        if (attribute == null) {
            attribute = OpenShiftServerUtils.getProjectAttribute(key, null, OpenShiftServerUtils.getDeployProject(server));
        }
        return attribute;
    }

    public static boolean isJavaProject(IServerAttributes server) {
        IProject p = OpenShiftServerUtils.getDeployProject(server);
        try {
            return ProjectUtils.isAccessible((IProject)p) && p.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)e);
            return false;
        }
    }

    private static void assertLegal(boolean legal, String message) throws CoreException {
        if (!legal) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(message));
        }
    }

    public static CoreException toCoreException(String msg, Exception e) {
        return new CoreException(StatusFactory.errorStatus((String)SERVER_PROJECT_QUALIFIER, (String)msg, (Throwable)e));
    }

    public static CoreException toCoreException(String msg) {
        return OpenShiftServerUtils.toCoreException(msg, null);
    }

    public static Collection<IPod> getAllPods(IServer server, IProgressMonitor monitor) {
        Connection connection = OpenShiftServerUtils.getConnection((IServerAttributes)server);
        if (connection == null) {
            return Collections.emptyList();
        }
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)server, connection, monitor);
        if (resource == null) {
            return Collections.emptyList();
        }
        ArrayList<IPod> collection = new ArrayList<IPod>();
        List<IPod> pods = connection.getResources("Pod", resource.getNamespace());
        List<IPod> servicePods = ResourceUtils.getPodsFor(resource, pods);
        collection.addAll(pods);
        collection.addAll(servicePods);
        return collection;
    }
}

