/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.jmx.integration.AbstractJBossJMXConnectionProvider;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.jolokia.JolokiaConnectionWrapper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class OpenshiftJMXConnectionProvider
extends AbstractJBossJMXConnectionProvider {
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String AUTHORIZATION_HEADER_VALUE_PREFIX = "Bearer ";
    public static final String PROVIDER_ID = "org.jboss.tools.openshift.core.server.OpenshiftJMXConnection";

    protected boolean getConnectionPersistenceBehavior() {
        return true;
    }

    protected boolean belongsHere(IServer server) {
        return server != null && "org.jboss.tools.openshift.server.type".equals(server.getServerType().getId()) && OpenShiftServerUtils.isJavaProject((IServerAttributes)server);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected IConnectionWrapper createConnection(IServer server) {
        Connection openshiftCon = OpenShiftServerUtils.getConnection((IServerAttributes)server);
        String url = this.computeJolokiaURL(server);
        if (url != null) {
            JolokiaConnectionWrapper cw = new JolokiaConnectionWrapper(){

                public IConnectionProvider getProvider() {
                    return ExtensionManager.getProvider((String)OpenshiftJMXConnectionProvider.PROVIDER_ID);
                }
            };
            cw.setId(server.getName());
            cw.setUrl(url);
            cw.setType("POST");
            cw.setIgnoreSSLErrors(true);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(AUTHORIZATION_HEADER_KEY, AUTHORIZATION_HEADER_VALUE_PREFIX + openshiftCon.getToken());
            cw.setHeaders(headers);
            return cw;
        }
        return null;
    }

    protected String computeJolokiaURL(IServer server) {
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)server, (IProgressMonitor)new NullProgressMonitor());
        if (resource != null) {
            String projName = resource.getNamespace();
            List<IPod> pods = ResourceUtils.getPodsFor(resource, (List<IPod>)resource.getProject().getResources("Pod"));
            if (!pods.isEmpty()) {
                String podName = pods.get(0).getName();
                String host = server.getHost();
                String portUrlPart = this.getOpenShiftPort(server);
                String jolokiaPort = this.getJolokiaPort(pods.get(0));
                return "https://" + host + portUrlPart + "/api/v1/namespaces/" + projName + "/pods/https:" + podName + ":" + jolokiaPort + "/proxy/jolokia/";
            }
        }
        return null;
    }

    protected String getJolokiaPort(IPod pod) {
        Optional<IEnvironmentVariable> envPort;
        String port = "8778";
        IReplicationController rc = ResourceUtils.getDeploymentConfigOrReplicationControllerFor(pod);
        if (rc != null && (envPort = rc.getEnvironmentVariables().stream().filter(env -> env.getName().equals("AB_JOLOKIA_PORT")).findFirst()).isPresent()) {
            port = envPort.get().getValue();
        }
        return port;
    }

    protected String getOpenShiftPort(IServer server) {
        int port = -1;
        try {
            URL connectionUrl = new URL(server.getAttribute("org.jboss.tools.openshift.Connection", ""));
            port = connectionUrl.getPort();
        }
        catch (MalformedURLException e) {
            OpenShiftCoreActivator.logError("Cannot determine port for JMX Connection from OpenShift connection URL", e);
        }
        return port != -1 ? ":" + port : "";
    }

    public String getName(IConnectionWrapper wrapper) {
        return ((JolokiaConnectionWrapper)wrapper).getId();
    }
}

