/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class PodDeploymentPathMetadata {
    private static final String DEFAULT_DEPLOYMENT_DIR = "/opt/app-root/src";
    private static final Pattern PATTERN_REDHAT_DEPLOYMENTS_DIR = Pattern.compile("\"com\\.redhat\\.deployments-dir\"[^\"]*\"([^\"]*)\",");
    private static final Pattern PATTERN_JBOSS_DEPLOYMENTS_DIR = Pattern.compile("\"org\\.jboss\\.deployments-dir\"[^\"]*\"([^\"]*)\",");
    private static final Pattern PATTERN_WOKRING_DIR = Pattern.compile("\"WorkingDir\"[^\"]*\"([^\"]*)\",");
    private String metadata;

    public PodDeploymentPathMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String get() {
        if (StringUtils.isEmpty((String)this.metadata)) {
            return null;
        }
        return this.getPodPath(this.metadata);
    }

    protected String useDefaultPathIfEmpty(String podPath) {
        if (StringUtils.isEmpty((String)podPath)) {
            return DEFAULT_DEPLOYMENT_DIR;
        }
        return podPath;
    }

    private String getPodPath(String imageMetaData) {
        String podPath = null;
        podPath = this.matchFirstGroup(imageMetaData, PATTERN_REDHAT_DEPLOYMENTS_DIR);
        if (podPath == null && (podPath = this.matchFirstGroup(imageMetaData, PATTERN_JBOSS_DEPLOYMENTS_DIR)) == null) {
            podPath = this.matchFirstGroup(imageMetaData, PATTERN_WOKRING_DIR);
        }
        return podPath;
    }

    private String matchFirstGroup(String imageStreamTag, Pattern pattern) {
        Matcher matcher = pattern.matcher(imageStreamTag);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }
}

