/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IRSyncable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IServerConsoleWriter;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OCBinaryOperation;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class RSync {
    private static final String POD_STATUS_RUNNING = "Running";
    private final IResource resource;
    private final String podPath;
    private final IServer server;
    private Connection connection;

    public RSync(IResource resource, String podPath, IServer server) {
        this.resource = resource;
        this.podPath = this.sanitizeUnixPath(podPath);
        this.server = server;
        this.connection = OpenShiftServerUtils.getConnection((IServerAttributes)server);
    }

    public void syncPodsToDirectory(final File localFolder, final MultiStatus status, final IServerConsoleWriter consoleWriter) {
        new OCBinaryOperation(){

            @Override
            protected void runOCBinary(MultiStatus multiStatus) {
                for (IPod pod : ResourceUtils.getPodsFor(RSync.this.resource, (List<IPod>)RSync.this.resource.getProject().getResources("Pod"))) {
                    try {
                        if (!RSync.POD_STATUS_RUNNING.equals(pod.getStatus())) continue;
                        RSync.this.syncPodToDirectory(pod, RSync.this.podPath, localFolder, consoleWriter);
                    }
                    catch (OpenShiftException | IOException e) {
                        status.add((IStatus)new Status(4, "org.jboss.tools.openshift.core", e.getMessage()));
                    }
                }
            }
        }.run(this.connection, status);
    }

    public void syncDirectoryToPods(final File localFolder, final MultiStatus status, final IServerConsoleWriter consoleWriter, IBinaryCapability.OpenShiftBinaryOption ... options) {
        new OCBinaryOperation(){

            @Override
            protected void runOCBinary(MultiStatus multiStatus) {
                for (IPod pod : ResourceUtils.getPodsFor(RSync.this.resource, (List<IPod>)RSync.this.resource.getProject().getResources("Pod"))) {
                    try {
                        if (!RSync.POD_STATUS_RUNNING.equals(pod.getStatus())) continue;
                        RSync.this.syncDirectoryToPod(pod, localFolder, RSync.this.podPath, consoleWriter);
                    }
                    catch (OpenShiftException | IOException e) {
                        status.add((IStatus)new Status(4, "org.jboss.tools.openshift.core", e.getMessage()));
                    }
                }
            }
        }.run(this.connection, status);
    }

    private void syncPodToDirectory(final IPod pod, final String podPath, File destination, final IServerConsoleWriter consoleWriter) throws IOException {
        destination.mkdirs();
        final String destinationPath = this.sanitizePath(destination.getAbsolutePath());
        pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

            public IRSyncable visit(IRSyncable rsyncable) {
                InputStream syncStream = rsyncable.sync((IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod), (IRSyncable.Peer)new IRSyncable.LocalPeer(destinationPath), new IBinaryCapability.OpenShiftBinaryOption[]{IBinaryCapability.OpenShiftBinaryOption.EXCLUDE_GIT_FOLDER, IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY});
                RSync.this.asyncWriteLogs(syncStream, consoleWriter);
                try {
                    rsyncable.await();
                }
                catch (InterruptedException e) {
                    OpenShiftCoreActivator.logError("Thread interrupted while running rsync", e);
                    Thread.currentThread().interrupt();
                }
                return rsyncable;
            }
        }, null);
    }

    private void syncDirectoryToPod(final IPod pod, File source, final String podPath, final IServerConsoleWriter consoleWriter) throws IOException {
        final String sourcePath = this.sanitizePath(source.getAbsolutePath());
        pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

            public IRSyncable visit(IRSyncable rsyncable) {
                InputStream syncStream = rsyncable.sync((IRSyncable.Peer)new IRSyncable.LocalPeer(sourcePath), (IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod), new IBinaryCapability.OpenShiftBinaryOption[]{IBinaryCapability.OpenShiftBinaryOption.EXCLUDE_GIT_FOLDER, IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY});
                RSync.this.asyncWriteLogs(syncStream, consoleWriter);
                try {
                    rsyncable.await();
                }
                catch (InterruptedException e) {
                    OpenShiftCoreActivator.logError("Thread interrupted while running rsync", e);
                    Thread.currentThread().interrupt();
                }
                return rsyncable;
            }
        }, null);
    }

    private void asyncWriteLogs(InputStream syncStream, IServerConsoleWriter consoleWriter) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(syncStream));){
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        consoleWriter.writeToShell(this.server.getId(), new String[]{line});
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                OpenShiftCoreActivator.logError("Error occurred while printing 'rsync' command output", e);
            }
        });
    }

    protected String sanitizePath(String path) {
        return this.sanitizePath(path, File.separator);
    }

    protected String sanitizeUnixPath(String path) {
        return this.sanitizePath(path, "/");
    }

    private String sanitizePath(String path, String slash) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(slash) || path.endsWith(String.valueOf(slash) + ".")) {
            return path;
        }
        return String.valueOf(path) + slash;
    }
}

