/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.adapter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.core.server.adapter.IProjectBuilderType;

public class ProjectBuilderTypeDetector {
    private static IProjectBuilderType UNKNOWN = new IProjectBuilderType(){

        @Override
        public boolean applies(IProject project) {
            return true;
        }

        @Override
        public String getTags(IProject project) {
            return "";
        }
    };
    private Collection<IProjectBuilderType> detectors;

    public ProjectBuilderTypeDetector() {
        this(new SimpleTypeDetector("eap", "pom.xml"), new SimpleTypeDetector("php", "index.php", "composer.json"), new SimpleTypeDetector("ruby", "Rakefile", "Gemfile", "config.ru"), new SimpleTypeDetector("python", "requirements.txt", "config.py"), new SimpleTypeDetector("perl", "index.pl", "cpanfile"), new SimpleTypeDetector("node", "app.json", "package.json"));
    }

    public ProjectBuilderTypeDetector(IProjectBuilderType ... detectors) {
        this.detectors = Arrays.asList(detectors);
    }

    protected IProjectBuilderType identify(IProject project) {
        if (project == null) {
            return UNKNOWN;
        }
        return this.detectors.stream().filter(d -> d.applies(project)).findFirst().orElse(UNKNOWN);
    }

    public String findTemplateFilter(IProject project) {
        if (project == null) {
            return null;
        }
        return this.identify(project).getTags(project);
    }

    private static class SimpleTypeDetector
    implements IProjectBuilderType {
        private String type;
        private Collection<String> files;

        SimpleTypeDetector(String type, String ... files) {
            this.type = type;
            this.files = files == null ? Collections.emptyList() : Arrays.asList(files);
        }

        @Override
        public String getTags(IProject project) {
            return this.type;
        }

        protected boolean hasAnyFile(IProject project, Collection<String> files) {
            return files.stream().filter(f -> project.getFile(f).exists()).findFirst().isPresent();
        }

        @Override
        public boolean applies(IProject project) {
            return ProjectUtils.isAccessible((IProject)project) && this.hasAnyFile(project, this.files);
        }

        public String toString() {
            return "[" + this.type + "] type detector";
        }
    }
}

