/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.behavior;

import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.util.ClassCollectingHCRListener;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.ServerProcess;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.core.OpenShiftCoreMessages;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.DockerImageLabels;
import org.jboss.tools.openshift.core.server.OpenShiftServerBehaviour;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.portforwarding.PortForwardingUtils;
import org.jboss.tools.openshift.internal.core.server.debug.DebugContext;
import org.jboss.tools.openshift.internal.core.server.debug.DebugLaunchConfigs;
import org.jboss.tools.openshift.internal.core.server.debug.IDebugListener;
import org.jboss.tools.openshift.internal.core.server.debug.OpenShiftDebugMode;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class OpenShiftLaunchController
extends AbstractSubsystemController
implements ISubsystemController,
ILaunchServerController {
    private static final String LAUNCH_DEBUG_PORT_PROP = "LOCAL_DEBUG_PORT";
    private static final int RECHECK_DELAY = 1000;
    private static final int PUBLISH_DELAY = 3000;
    private static final int DEBUGGER_LAUNCHED_TIMEOUT = 60000;
    private static final long WAIT_FOR_DEPLOYMENTCONFIG_TIMEOUT = 184320L;
    private static final long WAIT_FOR_DOCKERIMAGELABELS_TIMEOUT = 184320L;
    private static final String DEBUG_MODE = "debug";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        OpenShiftServerBehaviour beh = OpenShiftServerUtils.getOpenShiftServerBehaviour(configuration);
        String currentMode = beh.getServer().getMode();
        beh.setServerStarting();
        this.launchServerProcess(beh, launch, monitor);
        try {
            try {
                if (this.waitForDeploymentConfigReady(beh.getServer(), monitor)) {
                    DebugContext context = this.createDebugContext(beh, monitor);
                    this.toggleDebugging(mode, beh, context, monitor);
                    if (!this.isDebugMode(mode)) {
                        this.enableDevMode(context);
                    }
                    new OpenShiftDebugMode(context).execute(monitor);
                }
            }
            catch (Exception e) {
                mode = currentMode;
                throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not launch server {0}", (Object)beh.getServer().getName()), (Throwable)e));
            }
        }
        finally {
            this.setServerState(beh, mode, monitor);
        }
    }

    protected void launchServerProcess(OpenShiftServerBehaviour beh, ILaunch launch, IProgressMonitor monitor) {
        launch.addProcess((IProcess)new ServerProcess(launch, beh.getServer(), this.getLabel(launch.getLaunchMode())));
        beh.setServerStarting();
    }

    private String getLabel(String mode) {
        String label = null;
        switch (mode) {
            case "debug": {
                label = OpenShiftCoreMessages.DebugOnOpenshift;
                break;
            }
            case "profile": {
                label = OpenShiftCoreMessages.ProfileOnOpenshift;
                break;
            }
            default: {
                label = OpenShiftCoreMessages.RunOnOpenshift;
            }
        }
        return label;
    }

    protected boolean waitForDeploymentConfigReady(IServer server, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Waiting for deployment configs to become available...");
        Connection connection = OpenShiftServerUtils.getConnectionChecked((IServerAttributes)server);
        IResource resource = OpenShiftServerUtils.getResourceChecked((IServerAttributes)server, connection, monitor);
        long timeout = System.currentTimeMillis() + 184320L;
        while (ResourceUtils.getDeploymentConfigFor(resource, connection) == null) {
            if (this.sleep(1000, timeout, monitor)) continue;
            return false;
        }
        return true;
    }

    protected boolean waitForDockerImageLabelsReady(DockerImageLabels metadata, IProgressMonitor monitor) {
        monitor.subTask("Waiting for docker image to become available...");
        long timeout = System.currentTimeMillis() + 184320L;
        while (!metadata.load()) {
            if (this.sleep(1000, timeout, monitor)) continue;
            return false;
        }
        return true;
    }

    private boolean sleep(int sleep, long timeout, IProgressMonitor monitor) {
        return this.sleep(sleep) && System.currentTimeMillis() < timeout && !monitor.isCanceled();
    }

    private boolean sleep(int sleep) {
        try {
            Thread.sleep(sleep);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected void toggleDebugging(String mode, OpenShiftServerBehaviour beh, DebugContext context, IProgressMonitor monitor) {
        boolean enableDebugging = this.isDebugMode(mode);
        if (enableDebugging) {
            this.startDebugging(beh, context, monitor);
        } else {
            this.stopDebugging(context, monitor);
        }
    }

    protected void enableDevMode(DebugContext context) {
        new OpenShiftDebugMode(context).enableDevmode();
    }

    protected DebugContext createDebugContext(OpenShiftServerBehaviour beh, IProgressMonitor monitor) {
        monitor.subTask("Initialising debugging...");
        DockerImageLabels imageLabels = this.getDockerImageLabels(beh, monitor);
        IServer server = beh.getServer();
        String devmodeKey = StringUtils.defaultIfBlank((String)OpenShiftServerUtils.getDevmodeKey((IServerAttributes)server), (String)imageLabels.getDevmodeKey());
        String debugPortKey = StringUtils.defaultIfBlank((String)OpenShiftServerUtils.getDebugPortKey((IServerAttributes)server), (String)imageLabels.getDevmodePortKey());
        String debugPort = StringUtils.defaultIfBlank((String)OpenShiftServerUtils.getDebugPort((IServerAttributes)server), (String)imageLabels.getDevmodePortValue());
        return new DebugContext(beh.getServer(), devmodeKey, debugPortKey, debugPort);
    }

    private DockerImageLabels getDockerImageLabels(OpenShiftServerBehaviour beh, IProgressMonitor monitor) {
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)beh.getServer(), monitor);
        DockerImageLabels metadata = DockerImageLabels.getInstance(resource, (IControllableServerBehavior)beh);
        this.waitForDockerImageLabelsReady(metadata, monitor);
        return metadata;
    }

    protected void setServerState(OpenShiftServerBehaviour beh, String mode, IProgressMonitor monitor) {
        int state = this.pollState(monitor);
        String currentMode = beh.getServer().getMode();
        if (!Objects.equals(currentMode, mode)) {
            this.setModulesPublishing();
            if (state == 2 && beh.isRestarting()) {
                this.publishServer();
                beh.setRestarting(false);
            }
        }
        if (state == 2) {
            beh.setRunMode(mode);
            beh.setServerStarted();
        } else {
            beh.setServerStopped();
            beh.setRunMode(null);
        }
    }

    protected int pollState(IProgressMonitor monitor) {
        IResource resource = null;
        Throwable e = null;
        resource = OpenShiftServerUtils.getResource((IServerAttributes)this.getServer(), monitor);
        if (resource == null) {
            OpenShiftCoreActivator.pluginLog().logError("The OpenShift resource for server " + this.getServer().getName() + " could not be reached.", e);
            return 4;
        }
        return 2;
    }

    protected boolean isDebugMode() {
        return this.isDebugMode(this.getServer().getMode());
    }

    protected boolean isDebugMode(String mode) {
        return DEBUG_MODE.equals(mode);
    }

    private void setModulesPublishing() {
        IModule[] modules = this.getServer().getModules();
        int i = 0;
        while (i < modules.length) {
            ((Server)this.getServer()).setModulePublishState(new IModule[]{modules[i]}, 3);
            ++i;
        }
    }

    private void publishServer() {
        new Job("Publishing server " + this.getServer().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                return OpenShiftLaunchController.this.getServer().publish(1, monitor);
            }
        }.schedule(3000L);
    }

    protected void startDebugging(final OpenShiftServerBehaviour behaviour, DebugContext context, IProgressMonitor monitor) {
        IDebugListener listener = new IDebugListener(){

            @Override
            public void onDebugChange(DebugContext context, IProgressMonitor monitor) throws CoreException {
                int localPort = OpenShiftLaunchController.this.mapPortForwarding(context, monitor);
                ILaunch debuggerLaunch = OpenShiftLaunchController.this.attachRemoteDebugger(behaviour.getServer(), localPort, monitor);
                if (debuggerLaunch != null) {
                    OpenShiftLaunchController.this.overrideHotcodeReplace(behaviour.getServer(), debuggerLaunch);
                }
            }

            @Override
            public void onPodRestart(DebugContext debuggingContext, IProgressMonitor monitor) throws CoreException {
                this.onDebugChange(debuggingContext, monitor);
            }
        };
        context.setDebugListener(listener);
        new OpenShiftDebugMode(context).enableDebugging();
    }

    private void stopDebugging(DebugContext context, IProgressMonitor monitor) {
        IDebugListener listener = new IDebugListener(){

            @Override
            public void onDebugChange(DebugContext context, IProgressMonitor monitor) throws CoreException {
                DebugLaunchConfigs.get().terminateRemoteDebugger(OpenShiftLaunchController.this.getServer());
                OpenShiftLaunchController.this.unMapPortForwarding(context.getPod());
            }

            @Override
            public void onPodRestart(DebugContext debuggingContext, IProgressMonitor monitor) throws CoreException {
            }
        };
        context.setDebugListener(listener);
        new OpenShiftDebugMode(context).disableDebugging();
    }

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
    }

    private void unMapPortForwarding(IPod pod) throws CoreException {
        if (pod != null) {
            try {
                PortForwardingUtils.stopPortForwarding(pod, null);
            }
            catch (IOException e) {
                throw OpenShiftServerUtils.toCoreException("Unable to stop port forwarding", e);
            }
        }
    }

    protected int mapPortForwarding(DebugContext context, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Starting port forwarding...");
        IPod pod = context.getPod();
        if (pod == null) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not find running pod to forward to in server adapter \"{0}\"", (Object)this.getServer().getName())));
        }
        Set<IPortForwardable.PortPair> podPorts = PortForwardingUtils.getForwardablePorts(pod);
        int remotePort = context.getDebugPort();
        if (remotePort == -1) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"No pod port to forward to specified in server adapter \"{0}\"", (Object)this.getServer().getName())));
        }
        Optional<IPortForwardable.PortPair> debugPort = podPorts.stream().filter(p -> remotePort == p.getRemotePort()).findFirst();
        if (!debugPort.isPresent()) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Pod port specified in server adapter \"{0}\" is not present in pod \"{1}\"", (Object)this.getServer().getName(), (Object)pod.getName())));
        }
        if (PortForwardingUtils.isPortForwardingStarted(pod)) {
            return debugPort.get().getLocalPort();
        }
        if (this.mapPorts(podPorts, monitor)) {
            PortForwardingUtils.startPortForwarding(pod, podPorts, IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY);
            if (PortForwardingUtils.isPortForwardingStarted(pod)) {
                return debugPort.get().getLocalPort();
            }
        }
        throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not setup port forwarding to pod \"{0}\" in server adapter \"{1}\"", (Object)pod.getName(), (Object)this.getServer().getName())));
    }

    private boolean mapPorts(Set<IPortForwardable.PortPair> podPorts, IProgressMonitor monitor) {
        for (IPortForwardable.PortPair port : podPorts) {
            if (monitor.isCanceled()) {
                return false;
            }
            port.setLocalPort(SocketUtil.findFreePort());
            monitor.worked(1);
        }
        return true;
    }

    private ILaunch attachRemoteDebugger(IServer server, int localDebugPort, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Attaching remote debugger...");
        ILaunch ret = null;
        DebugLaunchConfigs launchConfigs = DebugLaunchConfigs.get();
        ILaunchConfiguration debuggerLaunchConfig = launchConfigs.getRemoteDebuggerLaunchConfiguration(server);
        ILaunchConfigurationWorkingCopy workingCopy = this.getLaunchConfigWorkingCopy(server, launchConfigs, debuggerLaunchConfig);
        if (workingCopy == null) {
            throw OpenShiftServerUtils.toCoreException(NLS.bind((String)"Could not modify launch config for server {0}", (Object)server.getName()));
        }
        IProject project = OpenShiftServerUtils.getDeployProject((IServerAttributes)server);
        launchConfigs.setupRemoteDebuggerLaunchConfiguration(workingCopy, project, localDebugPort);
        debuggerLaunchConfig = workingCopy.doSave();
        ret = this.lauchDebugger(debuggerLaunchConfig, localDebugPort, monitor);
        if (ret == null) {
            throw OpenShiftServerUtils.toCoreException(NLS.bind((String)"Could not start remote debugger to (forwarded) port {0} on localhost", (Object)localDebugPort));
        }
        monitor.worked(10);
        return ret;
    }

    private ILaunch lauchDebugger(ILaunchConfiguration debuggerLaunchConfig, int port, IProgressMonitor monitor) {
        ILaunch launch = null;
        int elapsed = 0;
        boolean launched = false;
        monitor.subTask("Waiting for remote debug port to become available...");
        while (!launched && elapsed < 60000) {
            try {
                launch = debuggerLaunchConfig.launch(DEBUG_MODE, (IProgressMonitor)new NullProgressMonitor());
                launch.setAttribute(LAUNCH_DEBUG_PORT_PROP, Integer.toString(port));
                launched = true;
            }
            catch (Exception exception) {
                if (monitor.isCanceled()) break;
                try {
                    Thread.sleep(1000L);
                    elapsed += 1000;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return launch;
    }

    private ILaunchConfigurationWorkingCopy getLaunchConfigWorkingCopy(IServer server, DebugLaunchConfigs launchConfigs, ILaunchConfiguration debuggerLaunchConfig) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy;
        if (debuggerLaunchConfig == null) {
            workingCopy = launchConfigs.createRemoteDebuggerLaunchConfiguration(server);
        } else {
            if (launchConfigs.isRunning(debuggerLaunchConfig)) {
                return null;
            }
            workingCopy = debuggerLaunchConfig.getWorkingCopy();
        }
        return workingCopy;
    }

    protected boolean overrideHotcodeReplace(IServer server, ILaunch launch) throws CoreException {
        IJavaHotCodeReplaceListener l = this.getHotCodeReplaceListener(server, launch);
        IDebugTarget[] targets = launch.getDebugTargets();
        if (targets != null && l != null) {
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof IJavaDebugTarget) {
                    ((IJavaDebugTarget)targets[i]).addHotCodeReplaceListener(l);
                }
                ++i;
            }
        }
        return true;
    }

    protected IJavaHotCodeReplaceListener getHotCodeReplaceListener(IServer server, final ILaunch launch) {
        return new ClassCollectingHCRListener(server, launch){

            protected void prePublish(IJavaDebugTarget target, IModule[] modules) {
                try {
                    this.getLaunch().terminate();
                }
                catch (DebugException de) {
                    OpenShiftCoreActivator.pluginLog().logError((Throwable)OpenShiftServerUtils.toCoreException("Unable to terminate debug session", (Exception)((Object)de)));
                }
            }

            protected void postPublish(IJavaDebugTarget target, IModule[] modules) {
                IServer server = this.getServer();
                this.waitModulesStarted(modules);
                this.executeJMXGarbageCollection(server, modules);
                OpenShiftLaunchController.this.sleep(3000);
                String portAttr = launch.getAttribute(OpenShiftLaunchController.LAUNCH_DEBUG_PORT_PROP);
                int port = -1;
                try {
                    port = Integer.parseInt(portAttr);
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    ILaunch newLaunch = OpenShiftLaunchController.this.attachRemoteDebugger(server, port, (IProgressMonitor)new NullProgressMonitor());
                    if (newLaunch != null) {
                        OpenShiftLaunchController.this.overrideHotcodeReplace(server, newLaunch);
                    }
                    this.setLaunch(newLaunch);
                }
                catch (CoreException ce) {
                    OpenShiftCoreActivator.pluginLog().logError((Throwable)OpenShiftServerUtils.toCoreException("Unable to restart debug session", (Exception)((Object)ce)));
                }
            }
        };
    }
}

