/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.behavior;

import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.model.IResource;
import java.io.File;
import java.io.FileFilter;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.wtp.core.console.ServerConsoleModel;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.StandardFileSystemPublishController;
import org.jboss.tools.common.util.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.RSync;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenShiftPublishController
extends StandardFileSystemPublishController
implements IPublishController {
    private RSync rsync = null;
    protected boolean syncDownFailed = false;

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        this.syncDownFailed = false;
        IServer server = this.getServer();
        this.rsync = this.createRsync(server, monitor);
        File localDirectory = this.getLocalFolder();
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Error while publishing server {0}.  Could not sync all pods to folder {1}", (Object)server.getName(), (Object)localDirectory.getAbsolutePath()), null);
        this.rsync.syncPodsToDirectory(localDirectory, status, ServerConsoleModel.getDefault().getConsoleWriter());
        if (!status.isOK()) {
            this.handleSyncDownFailure(status);
        }
        IProject deployProject = OpenShiftServerUtils.checkedGetDeployProject((IServerAttributes)server);
        if (!this.modulesIncludesMagicProject(this.getServer(), deployProject)) {
            this.publishModule(monitor, deployProject, localDirectory);
        }
    }

    private void publishModule(IProgressMonitor monitor, IProject deployProject, File localDirectory) throws CoreException {
        IModule projectModule = OpenShiftServerUtils.findProjectModule(deployProject);
        if (projectModule == null) {
            this.publishMagicProjectSimpleCopy(this.getServer(), localDirectory);
        } else {
            this.publishModule(2, 1, new IModule[]{projectModule}, monitor);
        }
    }

    protected void handleSyncDownFailure(MultiStatus status) throws CoreException {
        this.syncDownFailed = true;
        if (this.isSyncDownFailureCritical()) {
            this.clearRsync();
            throw new CoreException((IStatus)status);
        }
        OpenShiftCoreActivator.pluginLog().logWarning("Ignoring initial sync down error.", (Throwable)new CoreException((IStatus)status));
    }

    protected boolean isSyncDownFailureCritical() {
        return !this.isEapProfile();
    }

    protected boolean supportsJBoss7Markers() {
        return this.isEapProfile();
    }

    protected boolean isEapProfile() {
        String profile = ServerProfileModel.getProfile((IServerAttributes)this.getServer());
        return "openshift3.eap".equals(profile);
    }

    private void publishMagicProjectSimpleCopy(IServer server, File localDeploymentDirectory) throws CoreException {
        String sourcePath = OpenShiftServerUtils.getSourcePath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)sourcePath)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the source to publish.", (Object)server.getName())));
        }
        File source = new File(sourcePath);
        FileUtils.copyDir((File)source, (File)localDeploymentDirectory, (boolean)true, (boolean)true, (boolean)true, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return !filename.endsWith(".git") && !filename.endsWith(".gitignore") && !filename.endsWith(".svn") && !filename.endsWith(".settings") && !filename.endsWith(".project") && !filename.endsWith(".classpath");
            }
        });
    }

    private boolean modulesIncludesMagicProject(IServer server, IProject deployProject) {
        IModule[] all = server.getModules();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (all[i].getProject().equals((Object)deployProject)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        if (!this.hasRsync()) {
            return;
        }
        super.publishFinish(monitor);
        File localFolder = this.getLocalFolder();
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)this.getServer(), monitor);
        this.syncUp(localFolder, resource);
        this.deleteDoDeployMarkers(localFolder);
        this.loadPodPathIfEmpty(resource);
    }

    protected void syncUp(File localFolder, IResource resource) throws CoreException {
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync {0} to all pods running the service {1}", (Object)localFolder, (Object)resource.getName()), null);
        this.rsync.syncDirectoryToPods(localFolder, status, ServerConsoleModel.getDefault().getConsoleWriter(), new IBinaryCapability.OpenShiftBinaryOption[0]);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    protected void loadPodPathIfEmpty(IResource resource) throws CoreException {
        String podPath = OpenShiftServerUtils.getPodPath((IServerAttributes)this.getServer());
        if (StringUtils.isEmpty((String)podPath) && !StringUtils.isEmpty((String)(podPath = OpenShiftServerUtils.loadPodPath(resource, this.getServer())))) {
            this.fireUpdatePodPath(this.getServer(), podPath);
        }
    }

    private void fireUpdatePodPath(final IServer server, final String podPath) {
        new Job("Updating Pod Path"){

            protected IStatus run(IProgressMonitor monitor) {
                IServerWorkingCopy wc = server.createWorkingCopy();
                wc.setAttribute("org.jboss.tools.openshift.PodPath", podPath);
                try {
                    wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void deleteDoDeployMarkers(File localFolder) {
        Stream.of(localFolder.listFiles()).filter(file -> file.getName().endsWith(".dodeploy")).forEach(File::delete);
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (this.syncDownFailed) {
            return super.publishModule(4, deltaKind, module, monitor);
        }
        return super.publishModule(kind, deltaKind, module, monitor);
    }

    protected void launchUpdateModuleStateJob() throws CoreException {
    }

    protected File getLocalFolder() throws CoreException {
        return new File(this.getDeploymentOptions().getDeploymentsRootFolder(true));
    }

    protected RSync createRsync(IServer server, IProgressMonitor monitor) throws CoreException {
        return OpenShiftServerUtils.createRSync(server, monitor);
    }

    protected boolean hasRsync() {
        return this.rsync != null;
    }

    protected void clearRsync() {
        this.rsync = null;
    }
}

