/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.behavior;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.tools.openshift.core.server.OpenShiftServerBehaviour;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.server.debug.DebugLaunchConfigs;

public class OpenShiftShutdownController
extends AbstractSubsystemController
implements ISubsystemController,
IServerShutdownController {
    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    protected void log(int status, String message, Exception e) {
        OpenShiftCoreActivator.getDefault().getLog().log((IStatus)new Status(status, "org.jboss.tools.openshift.core", message, (Throwable)e));
    }

    public OpenShiftServerBehaviour getBehavior() {
        return (OpenShiftServerBehaviour)((Object)this.getServer().loadAdapter(OpenShiftServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
    }

    public void stop(boolean force) {
        OpenShiftServerBehaviour behavior = this.getBehavior();
        behavior.setServerStopping();
        try {
            DebugLaunchConfigs.get().terminateRemoteDebugger(behavior.getServer());
            behavior.setServerStopped();
        }
        catch (CoreException ce) {
            this.log(4, "Error shutting down server", (Exception)((Object)ce));
            this.getBehavior().setServerStarted();
        }
    }
}

