/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.behavior.eap;

import com.openshift.restclient.capability.IBinaryCapability;
import java.io.File;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7FSModuleStateVerifier;
import org.jboss.ide.eclipse.as.wtp.core.console.ServerConsoleModel;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.RSync;

public class OpenShiftEapModulesController
extends JBoss7FSModuleStateVerifier
implements ISubsystemController {
    protected int getRootModuleState(IServer server, IModule root, String deploymentName, IProgressMonitor monitor) throws Exception {
        this.syncDown(monitor);
        return super.getRootModuleState(server, root, deploymentName, monitor);
    }

    public int changeModuleStateTo(IModule[] module, int state, IProgressMonitor monitor) throws CoreException {
        this.syncDown(monitor);
        super.changeModuleStateTo(module, state, monitor);
        this.syncUp(monitor);
        this.deleteMarkers(".dodeploy");
        return state;
    }

    private void deleteMarkers(String suffix) throws CoreException {
        File localDeploymentDirectory = new File(this.getDeploymentOptions().getDeploymentsRootFolder(true));
        Stream.of(localDeploymentDirectory.listFiles()).filter(p -> p.getName().endsWith(suffix)).forEach(p -> {
            boolean bl = p.delete();
        });
    }

    private MultiStatus syncDown(IProgressMonitor monitor) throws CoreException {
        RSync rsync = OpenShiftServerUtils.createRSync(this.getServer(), monitor);
        File localDeploymentDirectory = new File(this.getDeploymentOptions().getDeploymentsRootFolder(true));
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync all pods to folder {0}.", (Object)localDeploymentDirectory.getAbsolutePath()), null);
        rsync.syncPodsToDirectory(localDeploymentDirectory, status, ServerConsoleModel.getDefault().getConsoleWriter());
        return status;
    }

    protected MultiStatus syncUp(IProgressMonitor monitor) throws CoreException {
        RSync rsync = OpenShiftServerUtils.createRSync(this.getServer(), monitor);
        File localDeploymentDirectory = new File(this.getDeploymentOptions().getDeploymentsRootFolder(true));
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync folder {0} to all pods.", (Object)localDeploymentDirectory.getAbsolutePath()), null);
        rsync.syncDirectoryToPods(localDeploymentDirectory, status, ServerConsoleModel.getDefault().getConsoleWriter(), new IBinaryCapability.OpenShiftBinaryOption[0]);
        return status;
    }
}

