/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server.behavior.springboot;

import com.openshift.restclient.model.IResource;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.RSync;
import org.jboss.tools.openshift.core.server.behavior.OpenShiftPublishController;

public class OpenShiftSpringBootPublishController
extends OpenShiftPublishController {
    private static final String POD_BASE_PATH = "/BOOT-INF/classes/";

    @Override
    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        if (!this.hasRsync()) {
            return;
        }
        super.publishFinish(monitor);
        File localFolder = this.getLocalFolder();
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)this.getServer(), monitor);
        this.syncUp(localFolder, resource);
        this.loadPodPathIfEmpty(resource);
    }

    @Override
    protected RSync createRsync(IServer server, IProgressMonitor monitor) throws CoreException {
        IResource resource = OpenShiftServerUtils.checkedGetResource(server, monitor);
        IPath podPath = new Path(OpenShiftServerUtils.getOrLoadPodPath(server, resource)).append(POD_BASE_PATH);
        return OpenShiftServerUtils.createRSync(resource, podPath.toString(), server);
    }

    protected boolean treatAsBinaryModule(IModule[] module) {
        return true;
    }
}

