/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.util;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class OpenShiftResourceUniqueId {
    private static final char UNIQUE_ID_PROJECT_NAME_DELIMITER = '@';

    public static String get(IResource resource) {
        if (resource == null || StringUtils.isEmpty((String)resource.getName()) || StringUtils.isEmpty((String)resource.getNamespace())) {
            return null;
        }
        if ("Service".equals(resource.getKind())) {
            return resource.getNamespace() + '@' + resource.getName();
        }
        return resource.getNamespace() + '@' + resource.getKind() + '@' + resource.getName();
    }

    public static String getProjectName(String uniqueId) {
        if (StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        int index = uniqueId.indexOf(64);
        if (index == -1) {
            return null;
        }
        return uniqueId.substring(0, index);
    }

    public static String getResourceName(String uniqueId) {
        if (StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        String[] comps = uniqueId.split(String.valueOf('@'));
        if (comps.length > 0) {
            return comps[comps.length - 1];
        }
        return null;
    }

    public static String getKind(String uniqueId) {
        if (StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        String[] comps = uniqueId.split(String.valueOf('@'));
        if (comps.length == 2) {
            return "Service";
        }
        if (comps.length == 3) {
            return comps[1];
        }
        return null;
    }

    public static <R extends IResource> R getByUniqueId(String uniqueId, Collection<R> resources) {
        if (resources == null || resources.isEmpty() || StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        for (IResource resource : resources) {
            if (!uniqueId.equals(OpenShiftResourceUniqueId.get(resource))) continue;
            return (R)resource;
        }
        return null;
    }
}

