/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenshiftServerLifecycleListener
implements IServerLifecycleListener {
    public void serverRemoved(IServer server) {
    }

    public void serverChanged(IServer server) {
    }

    public void serverAdded(IServer server) {
        if (server != null) {
            String typeId = server.getServerType().getId();
            boolean start = server.getAttribute("org.jboss.tools.openshift.SERVER_START_ON_CREATION", false);
            if ("org.jboss.tools.openshift.server.type".equals(typeId) && start) {
                this.startServerInJob(server);
            }
        }
    }

    private void startServerInJob(final IServer server) {
        new Job("Waiting for OpenShift pods to be ready"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    server.start("run", (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    OpenShiftCoreActivator.pluginLog().logError("Error starting server", (Throwable)ce);
                }
                return Status.OK_STATUS;
            }
        }.schedule(3000L);
    }
}

