/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core;

import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistryAdapter;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.core.Trace;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class WatchManager {
    private static final int[] FIBONACCI;
    private static final long BACKOFF_MILLIS = 5000L;
    private static final long BACKOFF_RESET;
    public static final String[] KINDS;
    private Map<WatchKey, AtomicReference<IWatcher>> watches = new ConcurrentHashMap<WatchKey, AtomicReference<IWatcher>>();

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 13;
        nArray[8] = 21;
        FIBONACCI = nArray;
        BACKOFF_RESET = (long)FIBONACCI[FIBONACCI.length - 1] * 5000L * 2L;
        KINDS = new String[]{"Build", "BuildConfig", "DeploymentConfig", "Event", "ImageStream", "Pod", "ReplicationController", "Route", "PersistentVolumeClaim", "Service", "Template", "Project"};
    }

    public static WatchManager getInstance() {
        return Holder.instance;
    }

    private WatchManager() {
        ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)new DeletedConnectionListener());
    }

    public void stopWatch(IProject project, IOpenShiftConnection connection) {
        String[] stringArray = KINDS;
        int n = KINDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            AtomicReference<IWatcher> watcherRef = this.watches.remove(new WatchKey(connection, project, kind));
            if (watcherRef != null && watcherRef.get() != null) {
                watcherRef.get().stop();
            }
            ++n2;
        }
    }

    public void startWatch(IProject project, IOpenShiftConnection connection) {
        AtomicReference watcherRef = new AtomicReference();
        String[] stringArray = KINDS;
        int n = KINDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            if (this.watches.putIfAbsent(new WatchKey(connection, project, kind), watcherRef) == null) {
                WatchListener listener = new WatchListener(project, connection, kind, 0, 0L);
                this.startWatch(project, 0, 0L, listener);
            }
            ++n2;
        }
    }

    private void startWatch(IProject project, int backoff, long lastConnect, WatchListener listener) {
        if (listener == null) {
            return;
        }
        listener.start(backoff, lastConnect);
    }

    /* synthetic */ WatchManager(WatchManager watchManager) {
        this();
    }

    private class DeletedConnectionListener
    extends ConnectionsRegistryAdapter {
        private DeletedConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionRemoved(IConnection connection) {
            if (!(connection instanceof Connection)) {
                return;
            }
            Connection conn = (Connection)connection;
            Map map = WatchManager.this.watches;
            synchronized (map) {
                WatchManager.this.watches.keySet().stream().filter(k -> ((WatchKey)k).connection.equals(conn)).collect(Collectors.toList()).forEach(k -> WatchManager.this.stopWatch(((WatchKey)k).project, ((WatchKey)k).connection));
            }
        }
    }

    private static class Holder {
        static WatchManager instance = new WatchManager(null);

        private Holder() {
        }
    }

    protected static enum State {
        STARTING,
        CONNECTED,
        DISCONNECTED,
        STOPPING;

    }

    private static class WatchKey {
        private IOpenShiftConnection connection;
        private IProject project;
        private String kind;

        private WatchKey(IOpenShiftConnection connection, IProject project, String kind) {
            this.connection = connection;
            this.project = project;
            this.kind = kind;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WatchKey other = (WatchKey)obj;
            if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
                return false;
            }
            if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
                return false;
            }
            return !(this.kind == null ? other.kind != null : !this.kind.equals(other.kind));
        }
    }

    public class WatchListener
    implements IOpenShiftWatchListener {
        private static final int NOT_FOUND = -1;
        private final IOpenShiftConnection conn;
        private final IProject project;
        private final String kind;
        private int backoff = 0;
        private long lastConnect = 0L;
        private AtomicReference<State> state = new AtomicReference<State>(State.DISCONNECTED);
        private List<IResource> resources = Collections.synchronizedList(new ArrayList());

        protected void setState(String state) {
            this.state.set(State.valueOf(state));
        }

        protected WatchListener(IProject project, IOpenShiftConnection conn, String kind, int backoff, long lastConnect) {
            Trace.debug("WatchManager Adding WatchListener for {0} and kind {1}", project.getName(), kind);
            this.project = project;
            this.conn = conn;
            this.backoff = backoff;
            this.lastConnect = lastConnect;
            this.kind = kind;
            if (System.currentTimeMillis() - lastConnect > BACKOFF_RESET) {
                backoff = 0;
            }
            Trace.debug("WatchManager Initial watch backoff of {0} ms", (long)FIBONACCI[backoff] * 5000L);
        }

        public void connected(List<IResource> resources) {
            Trace.debug("WatchManager Endpoint connected to {0} with {1} resources", this.conn.toString(), resources.size());
            this.resources.addAll(resources);
        }

        public void disconnected() {
            Trace.debug("WatchManager Endpoint disconnected to {0}.", this.conn.toString());
            this.state.set(State.DISCONNECTED);
        }

        public void error(Throwable err) {
            Trace.warn("WatchManager Reconnecting. There was an error watching connection {0}: ", err, this.conn.toString());
            this.restart();
        }

        private void restart() {
            if (State.DISCONNECTED.equals((Object)this.state.get())) {
                Trace.debug("Endpoint disconnected and skipping restart for project {0} and kind {1}", this.project.getName(), this.kind);
                return;
            }
            if (State.STARTING.equals((Object)this.state.get())) {
                Trace.debug("Returning early from restart.  Already starting for project {0} and kind {1}", this.project.getName(), this.kind);
            }
            try {
                this.conn.refresh((IResource)this.project);
                Trace.debug("WatchManager Rescheduling watch job for project {0} and kind {1}", this.project.getName(), this.kind);
                WatchManager.this.startWatch(this.project, this.backoff, this.lastConnect, this);
            }
            catch (Exception e) {
                Trace.debug("WatchManager Unable to rescheduling watch job for project {0} and kind {1}", e, this.project.getName(), this.kind);
                WatchManager.this.stopWatch(this.project, this.conn);
            }
        }

        public void start(int backoff, long lastConnect) {
            if (this.state.getAndSet(State.STARTING) == State.STARTING) {
                Trace.debug("In the process of starting watch already.  Returning early", new Object[0]);
                return;
            }
            this.backoff = backoff;
            this.lastConnect = lastConnect;
            Trace.info("Starting watch on project {0} for kind {1}", this.project.getName(), this.kind);
            IClient client = this.getClientFor(this.project);
            if (client != null) {
                new RestartWatchJob(client).schedule();
            }
        }

        private void connect(IClient client) {
            WatchKey key = new WatchKey(this.conn, this.project, this.kind);
            if (WatchManager.this.watches.containsKey(key)) {
                AtomicReference watcherRef = (AtomicReference)WatchManager.this.watches.get(key);
                watcherRef.set(client.watch(this.project.getName(), (IOpenShiftWatchListener)this, new String[]{this.kind}));
                this.state.set(State.CONNECTED);
                this.lastConnect = System.currentTimeMillis();
            }
        }

        private IClient getClientFor(IProject project) {
            IClient client = ResourceUtils.getClient((IResource)project);
            if (client == null) {
                Trace.warn("Unable to start watch.  Project {0} does not support IClientCapability", null, project.getName());
            }
            return client;
        }

        public void received(IResource resource, IOpenShiftWatchListener.ChangeType change) {
            Trace.debug("Watch received change in {0} state\n{1}", this.state, resource.toJson(false));
            if (State.CONNECTED == this.state.get()) {
                IResource newItem = null;
                IResource oldItem = null;
                int index = this.resources.indexOf(resource);
                if (IOpenShiftWatchListener.ChangeType.ADDED.equals((Object)change)) {
                    this.resources.add(resource);
                    newItem = resource;
                } else if (IOpenShiftWatchListener.ChangeType.DELETED.equals((Object)change)) {
                    oldItem = index > -1 ? this.resources.remove(index) : resource;
                } else if (IOpenShiftWatchListener.ChangeType.MODIFIED.equals((Object)change)) {
                    if (index > -1) {
                        oldItem = this.resources.remove(index);
                    }
                    this.resources.add(resource);
                    newItem = resource;
                }
                ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)this.conn, "openshift.resource", (Object)oldItem, (Object)newItem);
            }
        }

        private class RestartWatchJob
        extends Job {
            private IClient client;

            RestartWatchJob(IClient client) {
                super("OpenShift WatchManager Job");
                this.client = client;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    WatchListener.this.connect(this.client);
                }
                catch (Exception e) {
                    Trace.debug("Exception starting watch on project {0} and {1} kind", e, WatchListener.this.project.getName(), WatchListener.this.kind);
                    WatchListener watchListener = WatchListener.this;
                    watchListener.backoff = watchListener.backoff + 1;
                    if (WatchListener.this.backoff >= FIBONACCI.length) {
                        Trace.info("Exceeded backoff attempts trying to reconnect watch for {0} and kind {1}", WatchListener.this.project.getName(), WatchListener.this.kind);
                        WatchManager.this.watches.remove(WatchListener.this.project);
                        WatchListener.this.state.set(State.DISCONNECTED);
                        return Status.OK_STATUS;
                    }
                    long delay = (long)FIBONACCI[WatchListener.this.backoff] * 5000L;
                    Trace.debug("Delaying watch restart by {0}ms for project {1} and kinds {2} ", delay, WatchListener.this.project.getName(), WatchListener.this.kind);
                    new RestartWatchJob(this.client).schedule(delay);
                }
                return Status.OK_STATUS;
            }
        }
    }
}

