/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

public class ContentDigest {
    private static final String SEPARATOR = ":";
    private String algorithm;
    private String hex;

    public ContentDigest(String digest) {
        if (digest == null || digest.length() == 0) {
            throw new IllegalStateException("Empty digest not allowed");
        }
        String[] portions = digest.split(SEPARATOR);
        if (portions.length == 2) {
            this.algorithm = portions[0];
        }
        this.hex = portions[1];
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getHex() {
        return this.hex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.hex == null ? 0 : this.hex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentDigest other = (ContentDigest)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        return !(this.hex == null ? other.hex != null : !this.hex.equals(other.hex));
    }

    public String toString() {
        return String.valueOf(this.algorithm != null ? String.valueOf(this.algorithm) + SEPARATOR : "") + this.hex;
    }
}

