/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;

public class DockerConfigMetaData
implements IDockerImageMetadata {
    private IDockerImageInfo info;

    public DockerConfigMetaData(IDockerImageInfo info) {
        this.info = info;
    }

    private <C extends Collection<String>> C select(IDockerContainerConfig config, IDockerContainerConfig containerConfig, Function<IDockerContainerConfig, C> accessor, Supplier<C> defaultFactory) {
        Collection result = null;
        if (config != null) {
            result = (Collection)accessor.apply(config);
        }
        if ((result == null || result.isEmpty()) && containerConfig != null) {
            result = (Collection)accessor.apply(containerConfig);
        }
        if (result == null) {
            result = (Collection)defaultFactory.get();
        }
        return (C)result;
    }

    @Override
    public Set<String> exposedPorts() {
        if (this.info == null) {
            return Collections.emptySet();
        }
        return this.select(this.info.config(), this.info.containerConfig(), IDockerContainerConfig::exposedPorts, Collections::emptySet);
    }

    @Override
    public List<String> env() {
        if (this.info == null) {
            return Collections.emptyList();
        }
        return this.select(this.info.config(), this.info.containerConfig(), IDockerContainerConfig::env, Collections::emptyList);
    }

    @Override
    public Set<String> volumes() {
        if (this.info == null) {
            return Collections.emptySet();
        }
        return this.select(this.info.config(), this.info.containerConfig(), IDockerContainerConfig::volumes, Collections::emptySet);
    }

    @Override
    public Map<String, String> labels() {
        Map result = null;
        if (this.info.config() != null) {
            result = this.info.config().labels();
        }
        if ((result == null || result.isEmpty()) && this.info.containerConfig() != null) {
            result = this.info.containerConfig().labels();
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }
}

