/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.image.IImageStreamImport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;
import org.jboss.tools.openshift.internal.core.docker.ImageStreamTagMetaData;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class DockerImageUtils {
    private DockerImageUtils() {
    }

    public static boolean hasImage(IDockerConnection dockerConnection, String repoName, String tag) {
        for (IDockerImage image : dockerConnection.getImages()) {
            Map<String, List<String>> repoTags = DockerImageUtils.extractTagsByRepo(image.repoTags());
            for (Map.Entry<String, List<String>> entry : repoTags.entrySet()) {
                String repo = entry.getKey();
                List<String> tags = entry.getValue();
                if (repo == null || !repo.equals(repoName) || tags == null || !tags.contains(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, List<String>> extractTagsByRepo(List<String> repoTags) {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (String string : repoTags) {
            String repo;
            int indexOfColonChar = string.lastIndexOf(58);
            String string2 = repo = indexOfColonChar > -1 ? string.substring(0, indexOfColonChar) : string;
            if (!results.containsKey(repo)) {
                results.put(repo, new ArrayList());
            }
            if (indexOfColonChar <= -1) continue;
            ((List)results.get(repo)).add(string.substring(indexOfColonChar + 1));
        }
        for (Map.Entry entry : results.entrySet()) {
            Collections.sort((List)entry.getValue());
        }
        return results;
    }

    public static String extractImageNameAndTag(String imageName) {
        int lastIndexOfSlash = imageName.lastIndexOf(47);
        if (lastIndexOfSlash == -1) {
            return imageName;
        }
        return imageName.substring(lastIndexOfSlash + 1);
    }

    public static IDockerImageMetadata lookupImageMetadata(IProject project, DockerImageURI imageURI) {
        block4: {
            if (project != null && project.supports(IImageStreamImportCapability.class)) {
                String json;
                block5: {
                    IImageStreamImportCapability cap = (IImageStreamImportCapability)project.getCapability(IImageStreamImportCapability.class);
                    IImageStreamImport streamImport = cap.importImageMetadata(imageURI);
                    if (!ResourceUtils.isSuccessful(streamImport)) break block4;
                    json = streamImport.getImageJsonFor(imageURI.getTag());
                    if (!StringUtils.isBlank((String)json)) break block5;
                    OpenShiftCoreActivator.logError("Did not find metadata during ImportImageStream for " + imageURI.getAbsoluteUri(), null);
                    return null;
                }
                try {
                    return new ImageStreamTagMetaData(json);
                }
                catch (OpenShiftException e) {
                    OpenShiftCoreActivator.logError(NLS.bind((String)"Could not retrieve metadata for docker image {0}", (Object)imageURI), e);
                }
            }
        }
        return null;
    }
}

