/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.openshift.internal.core.docker.ContentDigest;

public class DockerManifestDigest {
    private static final Pattern REGEX_MANIFEST_DIGEST = Pattern.compile("([^:]*:\\/\\/)([^@]*)@(.*)");
    private String prefix;
    private ContentDigest digest;
    private String repository;

    public DockerManifestDigest(String imageId) {
        if (imageId == null || imageId.length() == 0) {
            throw new IllegalArgumentException("The imageId is empty.");
        }
        Matcher matcher = REGEX_MANIFEST_DIGEST.matcher(imageId);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(imageId) + "is not a docker manifest digest.");
        }
        this.prefix = matcher.group(1);
        this.repository = matcher.group(2);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRepository() {
        return this.repository;
    }

    public ContentDigest getDigest() {
        return this.digest;
    }
}

