/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;

public class ImageStreamTagMetaData
implements IDockerImageMetadata {
    private static final String[] ROOT = new String[]{"image", "dockerImageMetadata"};
    private static final String CONTAINER_CONFIG = "ContainerConfig";
    private static final String CONFIG = "Config";
    private static final String ENV = "Env";
    private static final String EXPOSED_PORT = "ExposedPorts";
    private static final String VOLUMES = "Volumes";
    private static final String LABELS = "Labels";
    private final ModelNode node;
    private final String[] CONFIG_ROOT;
    private final String[] PORT_KEY;
    private final String[] VOLUMES_KEY;
    private final String[] ENV_KEY;
    private final String[] LABELS_KEY;

    public ImageStreamTagMetaData(String json) {
        this.node = ModelNode.fromJSONString((String)json);
        ModelNode config = this.node.get(ROOT).get(CONTAINER_CONFIG);
        this.CONFIG_ROOT = ModelType.OBJECT == config.getType() && config.has(EXPOSED_PORT) ? (String[])ArrayUtils.add((Object[])ROOT, (Object)CONTAINER_CONFIG) : (String[])ArrayUtils.add((Object[])ROOT, (Object)CONFIG);
        this.PORT_KEY = (String[])ArrayUtils.add((Object[])this.CONFIG_ROOT, (Object)EXPOSED_PORT);
        this.VOLUMES_KEY = (String[])ArrayUtils.add((Object[])this.CONFIG_ROOT, (Object)VOLUMES);
        this.ENV_KEY = (String[])ArrayUtils.add((Object[])this.CONFIG_ROOT, (Object)ENV);
        this.LABELS_KEY = (String[])ArrayUtils.add((Object[])this.CONFIG_ROOT, (Object)LABELS);
    }

    @Override
    public Set<String> exposedPorts() {
        ModelNode ports = this.node.get(this.PORT_KEY);
        if (ports.isDefined()) {
            return ports.keys();
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> env() {
        ModelNode env = this.node.get(this.ENV_KEY);
        if (env.isDefined()) {
            return env.asList().stream().map(n -> n.asString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> labels() {
        ModelNode labels = this.node.get(this.LABELS_KEY);
        if (labels.isDefined()) {
            return labels.asPropertyList().stream().collect(Collectors.toMap(Property::getName, p -> p.getValue().asString()));
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<String> volumes() {
        ModelNode volumes = this.node.get(this.VOLUMES_KEY);
        if (volumes.isDefined()) {
            return volumes.keys();
        }
        return Collections.emptySet();
    }
}

