/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;

public class ImportImageMetaData
implements IDockerImageMetadata {
    private static final String[] ROOT = new String[]{"image", "dockerImageMetadata", "ContainerConfig"};
    private static final String[] PORTS = (String[])ArrayUtils.add((Object[])ROOT, (Object)"ExposedPorts");
    private static final String[] ENV = (String[])ArrayUtils.add((Object[])ROOT, (Object)"Env");
    private static final String[] LABELS = (String[])ArrayUtils.add((Object[])ROOT, (Object)"Labels");
    private static final String[] VOLUMES = (String[])ArrayUtils.add((Object[])ROOT, (Object)"Volumes");
    private final ModelNode node;

    public ImportImageMetaData(String json) {
        this.node = ModelNode.fromJSONString((String)json);
    }

    @Override
    public Set<String> exposedPorts() {
        ModelNode ports = this.node.get(PORTS);
        if (ports.isDefined()) {
            return ports.keys();
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> env() {
        ModelNode env = this.node.get(ENV);
        if (env.isDefined()) {
            return env.asList().stream().map(n -> n.asString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> labels() {
        ModelNode labels = this.node.get(LABELS);
        if (labels.isDefined()) {
            return labels.asPropertyList().stream().collect(Collectors.toMap(Property::getName, p -> p.getValue().asString()));
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<String> volumes() {
        ModelNode volumes = this.node.get(VOLUMES);
        if (volumes.isDefined()) {
            return volumes.keys();
        }
        return Collections.emptySet();
    }
}

