/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.docker;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnection2;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.docker.DockerImageUtils;

public class PushImageToRegistryJob
extends AbstractDelegatingMonitorJob {
    private final IDockerConnection dockerConnection;
    private final IRegistryAccount registryAccount;
    private final String imageName;
    private final String openshiftProject;

    public PushImageToRegistryJob(IDockerConnection dockerConnection, IRegistryAccount registryAccount, String openshiftProject, String imageName) {
        super("Pushing Docker image to OpenShift registry...");
        this.dockerConnection = dockerConnection;
        this.registryAccount = registryAccount;
        this.imageName = imageName;
        this.openshiftProject = openshiftProject;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        monitor.beginTask("Pushing image to registry", 1);
        String tmpImageName = this.getPushToRegistryImageName();
        try {
            try {
                this.dockerConnection.tagImage(this.imageName, tmpImageName);
                this.dockerConnection.pushImage(tmpImageName, this.registryAccount, this.getPushProgressHandler(tmpImageName));
            }
            catch (Exception e) {
                Status status = new Status(4, "org.jboss.tools.openshift.core", "Failed to push the selected Docker image into OpenShift registry", (Throwable)e);
                try {
                    this.dockerConnection.removeTag(tmpImageName);
                }
                catch (InterruptedException | DockerException e2) {
                    return new Status(2, "org.jboss.tools.openshift.core", "Pushed the selected Docker image into OpenShift registry but failed to untag it afterwards", e2);
                }
                monitor.done();
                return status;
            }
        }
        finally {
            try {
                this.dockerConnection.removeTag(tmpImageName);
            }
            catch (InterruptedException | DockerException e) {
                return new Status(2, "org.jboss.tools.openshift.core", "Pushed the selected Docker image into OpenShift registry but failed to untag it afterwards", e);
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IDockerProgressHandler getPushProgressHandler(String tmpImageName) {
        Assert.isTrue((boolean)(this.dockerConnection instanceof IDockerConnection2));
        return ((IDockerConnection2)this.dockerConnection).getDefaultPushImageProgressHandler(tmpImageName);
    }

    public String getPushToRegistryImageName() {
        try {
            URL registryURL = new URL(this.registryAccount.getServerAddress());
            String registryHostname = registryURL.getPort() == -1 ? registryURL.getHost() : String.valueOf(registryURL.getHost()) + ':' + registryURL.getPort();
            String tmpImageName = String.valueOf(registryHostname) + '/' + this.openshiftProject + '/' + DockerImageUtils.extractImageNameAndTag(this.imageName);
            return tmpImageName;
        }
        catch (MalformedURLException e) {
            OpenShiftCoreActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.core", "Failed to push the selected Docker image into OpenShift registry", (Throwable)e));
            return null;
        }
    }
}

