/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.models;

import com.openshift.restclient.model.IPort;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.NLS;

public class PortSpecAdapter
implements IPort {
    private String name;
    private String protocol;
    private int port;

    public PortSpecAdapter(String spec) {
        String[] parts = StringUtils.defaultIfBlank((String)spec, (String)"").split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException(NLS.bind((String)"Unable to determine port info from spec {0}", (Object)spec));
        }
        this.port = Integer.valueOf(parts[0]);
        this.protocol = parts[1].toUpperCase();
        this.name = this.getName(this.port, this.protocol);
    }

    public PortSpecAdapter(String name, String protocol, int port) {
        if (StringUtils.isBlank((String)protocol)) {
            throw new IllegalArgumentException("protocol must be set");
        }
        this.port = port;
        this.protocol = protocol;
        this.name = name == null ? this.getName(port, protocol) : name;
    }

    public String getName() {
        return this.name;
    }

    public int getContainerPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortSpecAdapter other = (PortSpecAdapter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }

    public String toString() {
        return "PortSpecAdapter [name=" + this.name + ", protocol=" + this.protocol + ", port=" + this.port + "]";
    }

    private String getName(int port, String protocol) {
        return NLS.bind((String)"{0}-{1}", (Object)port, (Object)protocol.toLowerCase());
    }
}

