/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.portforwarding;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.MultiStatus;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.core.OCBinaryOperation;

public class PortForwardingUtils {
    private static final Map<IPod, IPortForwardable> REGISTRY = new HashMap<IPod, IPortForwardable>();

    public static boolean isPortInUse(int port) {
        if (port < 0 || port >= 65536) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        ServerSocket socket = new ServerSocket(port);
        if (socket != null) {
            socket.close();
        }
        try {
            return false;
        }
        catch (Throwable throwable2) {
            try {
                if (socket != null) {
                    socket.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return true;
                }
            }
        }
    }

    public static boolean hasPortInUse(Collection<IPortForwardable.PortPair> ports) {
        return ports.stream().filter(port -> PortForwardingUtils.isPortInUse(port.getLocalPort())).findAny().isPresent();
    }

    public static boolean isPortForwardingStarted(IPod pod) {
        IPortForwardable capability = REGISTRY.get(pod);
        return capability != null && capability.isForwarding();
    }

    public static Set<IPortForwardable.PortPair> getForwardablePorts(IPod pod) {
        HashSet ports = new HashSet();
        IPortForwardable forwardable = REGISTRY.get(pod);
        if (forwardable != null && forwardable.getPortPairs() != null) {
            ports.addAll(forwardable.getPortPairs());
        } else if (pod.getContainerPorts() != null) {
            pod.getContainerPorts().stream().map(containerPort -> new IPortForwardable.PortPair(containerPort)).forEach(portPair -> {
                boolean bl = ports.add(portPair);
            });
        }
        return Collections.unmodifiableSet(ports);
    }

    public static IPortForwardable startPortForwarding(final IPod pod, final Collection<IPortForwardable.PortPair> ports, final IBinaryCapability.OpenShiftBinaryOption ... options) {
        if (PortForwardingUtils.isPortForwardingStarted(pod)) {
            return null;
        }
        IPortForwardable portForwarding = (IPortForwardable)pod.accept((CapabilityVisitor)new CapabilityVisitor<IPortForwardable, IPortForwardable>(){

            public IPortForwardable visit(final IPortForwardable portForwarding) {
                new OCBinaryOperation(){

                    @Override
                    protected void runOCBinary(MultiStatus multiStatus) {
                        portForwarding.forwardPorts(ports, options);
                    }
                }.run(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)pod), null);
                return portForwarding;
            }
        }, null);
        if (portForwarding != null) {
            REGISTRY.put(pod, portForwarding);
        }
        return portForwarding;
    }

    public static IPortForwardable startPortForwarding(IPod pod, IPortForwardable.PortPair port, IBinaryCapability.OpenShiftBinaryOption ... options) {
        return PortForwardingUtils.startPortForwarding(pod, Arrays.asList(port), options);
    }

    public static IPortForwardable stopPortForwarding(IPod pod, OutputStream stream) throws IOException {
        if (!PortForwardingUtils.isPortForwardingStarted(pod)) {
            return null;
        }
        IPortForwardable portForwarding = REGISTRY.remove(pod);
        if (portForwarding != null) {
            portForwarding.stop();
        }
        PortForwardingUtils.waitForPortsToGetFree(portForwarding.getPortPairs(), 5, stream);
        return portForwarding;
    }

    public static boolean waitForPortsToGetFree(Collection<IPortForwardable.PortPair> ports, int pollingTimeSeconds, OutputStream stream) throws IOException {
        int pollCount = pollingTimeSeconds * 10;
        int i = 0;
        while (i < pollCount) {
            if (!PortForwardingUtils.hasPortInUse(ports)) {
                return true;
            }
            if (i % 10 == 0 && stream != null) {
                stream.write("Waiting for port-forwarding to stop...\n".getBytes());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++i;
        }
        return false;
    }
}

