/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.preferences;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.OpenShiftCoreMessages;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.preferences.OCBinaryVersionValidator;

public enum OCBinary {
    WINDOWS("oc.exe"),
    OTHER("oc");

    private static final String CMD_BASE_NAME = "oc";
    private static final String OC_DEFAULTLOCATION_LINUX = "/usr/bin/oc";
    private String defaultNameForPlatform;
    private CommandLocationBinary locationBinary;

    public static OCBinary getInstance() {
        if ("win32".equals(Platform.getOS())) {
            return WINDOWS;
        }
        return OTHER;
    }

    private OCBinary(String defaultNameForPlatform) {
        this.defaultNameForPlatform = defaultNameForPlatform;
    }

    public String getName() {
        return this.defaultNameForPlatform;
    }

    public String[] getExtensions() {
        return this.getLocationBinary().getPossibleSuffixes();
    }

    public String getSystemPathLocation() {
        return this.getLocationBinary().findLocation();
    }

    private CommandLocationBinary getLocationBinary() {
        if (this.locationBinary == null) {
            this.locationBinary = new CommandLocationBinary(CMD_BASE_NAME);
            this.locationBinary.addPlatformLocation("linux", OC_DEFAULTLOCATION_LINUX);
            this.locationBinary.setDefaultPlatform("linux");
        }
        return this.locationBinary;
    }

    private String getWorkspaceLocation() {
        String location = OpenShiftCorePreferences.INSTANCE.getOCBinaryLocation();
        if (location == null || location.trim().isEmpty()) {
            location = this.getSystemPathLocation();
        }
        return location;
    }

    public String getLocation(IConnection connection) {
        String loc;
        IOpenShiftConnection c;
        Boolean override;
        if (connection instanceof IOpenShiftConnection && Boolean.TRUE.equals(override = (Boolean)(c = (IOpenShiftConnection)connection).getExtendedProperties().get("org.jbosstools.openshift.core.connection.ext.oc.override")) && StringUtils.isEmpty((String)(loc = (String)c.getExtendedProperties().get("org.jbosstools.openshift.core.connection.ext.oc.location")))) {
            return loc;
        }
        return this.getWorkspaceLocation();
    }

    public IStatus getStatus(IConnection connection, IProgressMonitor monitor) {
        String location = this.getLocation(connection);
        IStatus status = Status.OK_STATUS;
        if (new OCBinaryVersionValidator(location).isCompatibleForPublishing(monitor)) {
            if (location == null) {
                status = OpenShiftCoreActivator.statusFactory().errorStatus(OpenShiftCoreMessages.NoOCBinaryLocationErrorMessage);
            } else if (!new File(location).exists()) {
                status = OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)OpenShiftCoreMessages.OCBinaryLocationDontExistsErrorMessage, (Object)location));
            }
        } else {
            status = OpenShiftCoreActivator.statusFactory().warningStatus(OpenShiftCoreMessages.OCBinaryLocationIncompatibleErrorMessage);
        }
        return status;
    }
}

