/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.osgi.framework.Version;

public class OCBinaryVersionValidator {
    private static final Pattern OC_VERSION_LINE_PATTERN = Pattern.compile("oc[^v]*v(([0-9]{1,2})(\\.[0-9]{1,2})?(\\.[0-9]{1,2})?)([-\\.]([^+]*))?.*");
    private static final Version OC_MINIMUM_VERSION_FOR_RSYNC = Version.parseVersion((String)"1.1.1");
    private String path;

    public OCBinaryVersionValidator(String path) {
        this.path = path;
    }

    public Version getVersion(IProgressMonitor monitor) {
        Optional<Version> version = Optional.empty();
        if (this.path != null) {
            try {
                ProcessBuilder builder = new ProcessBuilder(this.path, "version");
                Process process = builder.start();
                version = this.parseVersion(process, monitor);
            }
            catch (IOException e) {
                OpenShiftCoreActivator.logError(e.getLocalizedMessage(), e);
            }
        }
        return version.orElse(Version.emptyVersion);
    }

    private Optional<Version> parseVersion(Process process, IProgressMonitor monitor) throws IOException {
        Optional<Version> version = Optional.empty();
        String line = null;
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            while (!monitor.isCanceled() && !version.isPresent() && (line = reader.readLine()) != null) {
                version = OCBinaryVersionValidator.parseVersion(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return version;
    }

    public static Optional<Version> parseVersion(String line) {
        if (StringUtils.isBlank((String)line)) {
            return Optional.empty();
        }
        Matcher matcher = OC_VERSION_LINE_PATTERN.matcher(line);
        Version version = null;
        if (matcher.matches()) {
            try {
                String group6;
                version = Version.parseVersion((String)matcher.group(1));
                if (matcher.groupCount() > 1 && version.getQualifier().isEmpty() && (group6 = matcher.group(6)) != null) {
                    group6 = group6.replaceAll("[^a-zA-Z0-9_-]", "_");
                    version = new Version(version.getMajor(), version.getMinor(), version.getMicro(), group6);
                }
            }
            catch (IllegalArgumentException e) {
                OpenShiftCoreActivator.logError(NLS.bind((String)"Could not parse oc version {0}.", (Object)line), e);
            }
        }
        return Optional.ofNullable(version);
    }

    public boolean isCompatibleForPublishing(IProgressMonitor monitor) {
        return OCBinaryVersionValidator.isCompatibleForPublishing(this.getVersion(monitor));
    }

    public static boolean isCompatibleForPublishing(Version version) {
        return version != null && version.compareTo(OC_MINIMUM_VERSION_FOR_RSYNC) >= 0;
    }
}

