/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import com.openshift.restclient.model.IPod;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.internal.core.server.debug.IDebugListener;

public class DebugContext {
    public static final String DEFAULT_DEVMODE_KEY = "DEV_MODE";
    public static final String DEFAULT_DEBUG_PORT_KEY = "DEBUG_PORT";
    public static final String DEFAULT_DEBUG_PORT = "8787";
    public static final int NO_DEBUG_PORT = -1;
    private IServer server;
    private boolean debugEnabled;
    private boolean devmodeEnabled;
    private String devmodeKey;
    private String debugPortKey;
    private int debugPort = -1;
    private IDebugListener listener;
    private IPod pod;

    public DebugContext(IServer server) {
        this(server, DEFAULT_DEVMODE_KEY, DEFAULT_DEBUG_PORT_KEY, DEFAULT_DEBUG_PORT);
    }

    public DebugContext(IServer server, String devmodeKey, String debugPortKey, String debugPort) {
        Assert.isNotNull((Object)server);
        Assert.isNotNull((Object)devmodeKey);
        Assert.isNotNull((Object)debugPortKey);
        Assert.isNotNull((Object)debugPort);
        this.server = server;
        this.devmodeKey = devmodeKey;
        this.debugPortKey = debugPortKey;
        this.debugPort = this.getDebugPort(debugPort);
    }

    public IServer getServer() {
        return this.server;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    protected void setDevmodeEnabled(boolean devmodeEnabled) {
        this.devmodeEnabled = devmodeEnabled;
    }

    public boolean isDevmodeEnabled() {
        return this.devmodeEnabled;
    }

    protected void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        this.devmodeEnabled = debugEnabled;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public IPod getPod() {
        return this.pod;
    }

    public void setDebugListener(IDebugListener listener) {
        this.listener = listener;
    }

    IDebugListener getDebugListener() {
        return this.listener;
    }

    String getDevmodeKey() {
        return this.devmodeKey;
    }

    String getDebugPortKey() {
        return this.debugPortKey;
    }

    void setPod(IPod pod) {
        this.pod = pod;
    }

    int getDebugPort(String debugPort) {
        if (StringUtils.isBlank((String)debugPort)) {
            return -1;
        }
        try {
            return Integer.parseInt(debugPort);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

