/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;

public class DebugLaunchConfigs {
    private ILaunchManager launchManager;

    public static DebugLaunchConfigs get() {
        return DebugLaunchConfigs.get(DebugPlugin.getDefault().getLaunchManager());
    }

    public static DebugLaunchConfigs get(ILaunchManager launchManager) {
        return new DebugLaunchConfigs(launchManager);
    }

    private DebugLaunchConfigs(ILaunchManager launchManager) {
        this.launchManager = launchManager;
    }

    public ILaunchConfiguration getRemoteDebuggerLaunchConfiguration(IServer server) throws CoreException {
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfiguration[] launchConfigs = this.launchManager.getLaunchConfigurations(launchConfigurationType);
        String name = DebugLaunchConfigs.getRemoteDebuggerLaunchConfigurationName(server);
        Optional<ILaunchConfiguration> maybeLaunch = Stream.of(launchConfigs).filter(lc -> name.equals(lc.getName())).findFirst();
        return maybeLaunch.orElse(null);
    }

    public ILaunchConfigurationWorkingCopy createRemoteDebuggerLaunchConfiguration(IServer server) throws CoreException {
        String name = DebugLaunchConfigs.getRemoteDebuggerLaunchConfigurationName(server);
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        return launchConfigurationType.newInstance(null, name);
    }

    public void setupRemoteDebuggerLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProject project, int debugPort) throws CoreException {
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        HashMap<String, String> connectMap = new HashMap<String, String>(2);
        String portString = String.valueOf(debugPort);
        connectMap.put("port", portString);
        connectMap.put("hostname", "localhost");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
        if (project != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
    }

    public boolean isRunning(ILaunchConfiguration launchConfiguration) {
        return this.getLaunches().filter(l -> !l.isTerminated() && this.launchMatches((ILaunch)l, launchConfiguration)).findFirst().isPresent();
    }

    private boolean launchMatches(ILaunch l, ILaunchConfiguration launchConfiguration) {
        return Objects.equals(l.getLaunchConfiguration(), launchConfiguration);
    }

    public static String getRemoteDebuggerLaunchConfigurationName(IServer server) {
        return "Remote debugger to " + server.getName();
    }

    public void terminateRemoteDebugger(IServer server) throws CoreException {
        ILaunchConfiguration launchConfig = this.getRemoteDebuggerLaunchConfiguration(server);
        if (launchConfig == null) {
            return;
        }
        ArrayList errors = new ArrayList();
        this.getLaunches().filter(l -> launchConfig.equals(l.getLaunchConfiguration())).filter(l -> l.canTerminate()).forEach(l -> this.terminate((ILaunch)l, errors));
        if (!errors.isEmpty()) {
            MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 4, errors.toArray(new IStatus[errors.size()]), "Failed to terminate remote launch configuration", null);
            throw new CoreException((IStatus)status);
        }
    }

    private Stream<ILaunch> getLaunches() {
        return Stream.of(this.launchManager.getLaunches());
    }

    private void terminate(ILaunch launch, Collection<IStatus> errors) {
        try {
            launch.terminate();
        }
        catch (DebugException e) {
            errors.add(e.getStatus());
        }
    }
}

