/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IEnvironmentVariable;
import org.apache.commons.lang.StringUtils;

public class EnvironmentVariables {
    private IDeploymentConfig dc;

    EnvironmentVariables(IDeploymentConfig dc) {
        this.dc = dc;
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.get(this.dc, key));
    }

    public String getString(String key) {
        return this.get(this.dc, key);
    }

    private String get(IDeploymentConfig dc, String key) {
        if (dc == null || dc.getEnvironmentVariables() == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        return dc.getEnvironmentVariables().stream().filter(ev -> key.equals(ev.getName())).findFirst().map(IEnvironmentVariable::getValue).orElse(null);
    }

    public void set(String key, String value) {
        if (this.dc == null) {
            return;
        }
        this.dc.setEnvironmentVariable(key, value);
    }

    public void remove(String key) {
        this.dc.removeEnvironmentVariable(key);
    }
}

