/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.probe.IProbe;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.server.debug.DebugContext;

public class LivenessProbe {
    public static final int INITIAL_DELAY = 3600;
    private IDeploymentConfig dc;

    LivenessProbe(IDeploymentConfig dc) {
        this.dc = dc;
    }

    public boolean setInitialDelay(DebugContext context, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)"Setting liveness probe initial delay to {0}", (Object)3600));
        IProbe probe = this.getLivenessProbe(this.dc);
        if (probe == null) {
            return false;
        }
        int initialDelay = probe.getInitialDelaySeconds();
        if (initialDelay >= 3600) {
            return false;
        }
        OpenShiftServerUtils.setLivenessProbeInitialDelay(initialDelay, (IServerAttributes)context.getServer());
        probe.setInitialDelaySeconds(3600);
        return true;
    }

    public boolean resetInitialDelay(DebugContext context, IProgressMonitor monitor) throws CoreException {
        int delay = OpenShiftServerUtils.getLivenessProbeInitialDelay((IServerAttributes)context.getServer());
        if (delay == -1) {
            return false;
        }
        IProbe probe = this.getLivenessProbe(this.dc);
        if (probe == null) {
            return false;
        }
        monitor.subTask("Resetting liveness probe initial delay...");
        probe.setInitialDelaySeconds(delay);
        OpenShiftServerUtils.setLivenessProbeInitialDelay(-1, (IServerAttributes)context.getServer());
        return true;
    }

    private IProbe getLivenessProbe(IDeploymentConfig dc) {
        Collection containers = dc.getContainers();
        if (containers == null) {
            return null;
        }
        IContainer container = containers.stream().findFirst().orElse(null);
        if (container == null) {
            return null;
        }
        return container.getLivenessProbe();
    }
}

