/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.route.IRoute;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.models.PortSpecAdapter;
import org.jboss.tools.openshift.internal.core.server.debug.DebugContext;
import org.jboss.tools.openshift.internal.core.server.debug.EnvironmentVariables;
import org.jboss.tools.openshift.internal.core.server.debug.IDebugListener;
import org.jboss.tools.openshift.internal.core.server.debug.LivenessProbe;
import org.jboss.tools.openshift.internal.core.server.debug.RouteTimeout;
import org.jboss.tools.openshift.internal.core.util.NewPodDetectorJob;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class OpenShiftDebugMode {
    private static final String DEBUG_PORT_PROTOCOL = "TCP";
    private static final String DEBUG_PORT_NAME = "debug";
    protected DebugContext context;

    public OpenShiftDebugMode(DebugContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
    }

    public OpenShiftDebugMode enableDebugging() {
        this.context.setDebugEnabled(true);
        this.context.setDevmodeEnabled(true);
        return this;
    }

    public OpenShiftDebugMode disableDebugging() {
        this.context.setDebugEnabled(false);
        this.context.setDevmodeEnabled(false);
        return this;
    }

    private boolean isDebugEnabled(IDeploymentConfig dc, String devmodeKey, String debugPortKey, int requestedDebugPort, boolean enableRequested) {
        boolean debugEnabled = false;
        EnvironmentVariables env = new EnvironmentVariables(dc);
        boolean devmodeEnabled = env.getBoolean(devmodeKey);
        if (devmodeEnabled) {
            String debugPort = env.getString(debugPortKey);
            debugEnabled = enableRequested ? !StringUtils.isBlank((String)debugPort) && this.context.getDebugPort(debugPort) == requestedDebugPort : !StringUtils.isBlank((String)debugPort);
        }
        return debugEnabled;
    }

    public OpenShiftDebugMode enableDevmode() {
        this.context.setDevmodeEnabled(true);
        return this;
    }

    public OpenShiftDebugMode disableDevmode() {
        this.context.setDevmodeEnabled(false);
        return this;
    }

    public OpenShiftDebugMode execute(IProgressMonitor monitor) throws CoreException {
        Connection connection = OpenShiftServerUtils.getConnection((IServerAttributes)this.context.getServer());
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)this.context.getServer(), monitor);
        IDeploymentConfig dc = this.getDeploymentConfig(resource, connection, monitor);
        if (dc == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Could not find deployment config for resource {0}. Your build might be still running and pods not created yet or there might be no labels on your pods pointing to the wanted deployment config.", (Object)(resource != null ? resource.getName() : ""))));
        }
        boolean dcUpdated = this.updateDc(dc, connection, monitor);
        IPod pod = this.getPod(dcUpdated, dc, connection, monitor);
        this.context.setPod(pod);
        this.toggleRouteTimeout(resource, connection, this.context, monitor);
        this.toggleDebugger(this.context, monitor);
        return this;
    }

    private void toggleRouteTimeout(IResource resource, Connection connection, DebugContext context, IProgressMonitor monitor) throws CoreException {
        if (context.isDebugEnabled()) {
            this.setRouteTimeout(resource, connection, monitor);
        } else {
            this.resetRouteTimeout(resource, connection, monitor);
        }
    }

    private void setRouteTimeout(IResource resource, Connection connection, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Increasing route timeout while debugging...");
        IRoute route = new RouteTimeout(resource, connection).set(this.context, monitor);
        if (route != null) {
            this.safeSend((IResource)route, connection, monitor);
        }
    }

    private void resetRouteTimeout(IResource resource, Connection connection, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Clearing/restoring route timeout after debugging...");
        IRoute route = new RouteTimeout(resource, connection).reset(this.context, monitor);
        if (route != null) {
            this.safeSend((IResource)route, connection, monitor);
        }
    }

    private boolean updateDc(IDeploymentConfig dc, Connection connection, IProgressMonitor monitor) throws CoreException {
        boolean dcUpdated = this.updateDebugmode(dc, this.context, monitor) | this.updateDevmode(dc, this.context, monitor) | this.updateLifenessProbe(dc, this.context, monitor);
        if (dcUpdated) {
            this.send((IResource)dc, connection, monitor);
        }
        return dcUpdated;
    }

    protected IPod getPod(boolean dcUpdated, IDeploymentConfig dc, Connection connection, IProgressMonitor monitor) throws CoreException {
        IPod pod = null;
        pod = dcUpdated ? this.waitForNewPod(dc, monitor) : this.getExistingPod(dc, connection, monitor);
        return pod;
    }

    private void toggleDebugger(DebugContext context, IProgressMonitor monitor) throws CoreException {
        IDebugListener listener;
        if (context.isDebugEnabled() && (listener = context.getDebugListener()) != null) {
            listener.onDebugChange(context, monitor);
        }
    }

    protected IPod getExistingPod(IDeploymentConfig dc, Connection connection, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)"Retrieving existing pod for deployment config {0}.", (Object)dc.getName()));
        List<IPod> allPods = connection.getResources("Pod", dc.getNamespace());
        return ResourceUtils.getPodsFor(dc, allPods).stream().findFirst().orElse(null);
    }

    private boolean updateDebugmode(IDeploymentConfig dc, DebugContext context, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)(context.isDebugEnabled() ? "Enabling" : "Disabling debugging for deployment config {0}"), (Object)dc.getName()));
        boolean needsUpdate = this.needsDebugUpdate(dc, context);
        if (needsUpdate) {
            this.updateContainerDebugPort(dc, context);
            this.updateDebugEnvVariables(dc, context);
        }
        return needsUpdate;
    }

    private boolean needsDebugUpdate(IDeploymentConfig dc, DebugContext context) {
        boolean debugEnabled = this.isDebugEnabled(dc, context.getDevmodeKey(), context.getDebugPortKey(), context.getDebugPort(), context.isDebugEnabled());
        return debugEnabled ^ context.isDebugEnabled();
    }

    private void updateDebugEnvVariables(IDeploymentConfig dc, DebugContext context) {
        if (context.isDebugEnabled()) {
            dc.setEnvironmentVariable(context.getDebugPortKey(), String.valueOf(context.getDebugPort()));
            dc.setEnvironmentVariable(context.getDevmodeKey(), String.valueOf(context.isDebugEnabled()));
        } else {
            dc.removeEnvironmentVariable(context.getDebugPortKey());
            dc.removeEnvironmentVariable(context.getDevmodeKey());
        }
    }

    private void updateContainerDebugPort(IDeploymentConfig dc, DebugContext context) {
        Collection containers = dc.getContainers();
        if (CollectionUtils.isEmpty((Collection)containers)) {
            return;
        }
        IContainer firstContainer = (IContainer)containers.iterator().next();
        IPort currentContainerPort = this.getCurrentContainerPort(firstContainer.getPorts());
        boolean modified = false;
        HashSet<IPort> ports = new HashSet<IPort>(firstContainer.getPorts());
        modified = context.isDebugEnabled() ? this.addReplaceDebugPort(context.getDebugPort(), currentContainerPort, ports) : this.removeDebugPort(currentContainerPort, ports);
        if (modified) {
            firstContainer.setPorts(ports);
        }
    }

    private IPort getCurrentContainerPort(Set<IPort> ports) {
        return ports.stream().filter(p -> DEBUG_PORT_NAME.equals(p.getName())).findFirst().orElse(null);
    }

    private boolean addReplaceDebugPort(int debugPort, IPort existing, Set<IPort> ports) {
        boolean modified = false;
        if (this.matchesPort(debugPort, existing)) {
            ports.remove(existing);
            modified = true;
        }
        PortSpecAdapter newPort = new PortSpecAdapter(DEBUG_PORT_NAME, DEBUG_PORT_PROTOCOL, debugPort);
        return modified |= ports.add(newPort);
    }

    private boolean matchesPort(int debugPort, IPort currentContainerPort) {
        return currentContainerPort != null && currentContainerPort.getContainerPort() != debugPort;
    }

    private boolean removeDebugPort(IPort currentContainerPort, Set<IPort> ports) {
        boolean modified = false;
        if (currentContainerPort != null) {
            ports.remove(currentContainerPort);
            modified = true;
        }
        return modified;
    }

    private boolean updateDevmode(IDeploymentConfig dc, DebugContext context, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)"Enabling devmode for deployment config {0}", (Object)dc.getName()));
        boolean needsUpdate = this.needsDevmodeUpdate(dc, context);
        if (needsUpdate) {
            this.updateDevmodeEnvVar(context.isDevmodeEnabled(), dc, context);
        }
        return needsUpdate;
    }

    private boolean needsDevmodeUpdate(IDeploymentConfig dc, DebugContext context) {
        boolean devmodeEnabled = new EnvironmentVariables(dc).getBoolean(context.getDevmodeKey());
        return devmodeEnabled ^ context.isDevmodeEnabled();
    }

    private void updateDevmodeEnvVar(boolean enable, IDeploymentConfig dc, DebugContext context) {
        if (enable) {
            new EnvironmentVariables(dc).set(context.getDevmodeKey(), String.valueOf(enable));
        } else {
            new EnvironmentVariables(dc).remove(context.getDevmodeKey());
        }
    }

    private boolean updateLifenessProbe(IDeploymentConfig dc, DebugContext context, IProgressMonitor monitor) throws CoreException {
        if (context.isDebugEnabled()) {
            return new LivenessProbe(dc).setInitialDelay(context, monitor);
        }
        return new LivenessProbe(dc).resetInitialDelay(context, monitor);
    }

    protected void safeSend(IResource resource, Connection connection, IProgressMonitor monitor) {
        try {
            this.send(resource, connection, monitor);
        }
        catch (CoreException e) {
            OpenShiftCoreActivator.pluginLog().logError(e.getMessage());
        }
    }

    protected void send(IResource resource, Connection connection, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)"Updating {0}...", (Object)resource.getName()));
        try {
            connection.updateResource(resource);
        }
        catch (OpenShiftException e) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not update resource {0}.", (Object)resource.getName()), (Throwable)e));
        }
    }

    private IDeploymentConfig getDeploymentConfig(IResource resource, Connection connection, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)"Retrieving deployment config for resource {0}.", (Object)resource.getName()));
        return ResourceUtils.getDeploymentConfigFor(resource, connection);
    }

    protected IPod waitForNewPod(IDeploymentConfig dc, IProgressMonitor monitor) throws CoreException {
        NewPodDetectorJob newPodDetector = new NewPodDetectorJob(dc);
        newPodDetector.schedule();
        return this.waitFor(newPodDetector, monitor);
    }

    protected IPod waitFor(NewPodDetectorJob podDetector, IProgressMonitor monitor) throws CoreException {
        try {
            podDetector.join(NewPodDetectorJob.TIMEOUT, monitor);
            IStatus result = podDetector.getResult();
            if (result == null) {
                throw new CoreException(podDetector.getTimeOutStatus());
            }
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            return podDetector.getPod();
        }
        catch (InterruptedException | OperationCanceledException e) {
            throw new OpenShiftCoreException(e);
        }
    }
}

