/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.debug;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.server.debug.DebugContext;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class RouteTimeout {
    public static final String ROUTE_DEBUG_TIMEOUT = "1h";
    private IResource resource;
    private Connection connection;

    RouteTimeout(IResource resource, Connection connection) {
        this.resource = resource;
        this.connection = connection;
    }

    public IRoute set(DebugContext context, IProgressMonitor monitor) throws CoreException {
        IRoute route = this.getRoute(this.resource, this.connection, monitor);
        if (route == null) {
            OpenShiftCoreActivator.pluginLog().logInfo(NLS.bind((String)"Could not increase timeout for debugging: could not find any route for resource {0}", (Object)this.resource.getName()));
            return null;
        }
        monitor.subTask(NLS.bind((String)"Setting haproxy timeout for route {0}...", (Object)route.getName()));
        String currentTimeout = this.getAnnotation(route);
        if (!StringUtils.isBlank((String)currentTimeout)) {
            OpenShiftServerUtils.setRouteTimeout(currentTimeout, (IServerAttributes)context.getServer());
            if (StringUtils.equals((String)ROUTE_DEBUG_TIMEOUT, (String)currentTimeout)) {
                return null;
            }
        }
        this.setAnnotation(ROUTE_DEBUG_TIMEOUT, route);
        return route;
    }

    public IRoute reset(DebugContext context, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)"Getting route for resource {0}...", (Object)this.resource.getName()));
        IRoute route = this.getRoute(this.resource, this.connection, monitor);
        if (route == null) {
            OpenShiftCoreActivator.pluginLog().logInfo(NLS.bind((String)"Could not find any route for resource {0}", (Object)this.resource.getName()));
            return null;
        }
        monitor.subTask(NLS.bind((String)"Removing/restoring timeout for route {0}", (Object)route.getName()));
        if (OpenShiftServerUtils.hasRouteTimeout((IServerAttributes)context.getServer())) {
            this.setAnnotation(OpenShiftServerUtils.getRouteTimeout((IServerAttributes)context.getServer()), route);
            OpenShiftServerUtils.setRouteTimeout(null, (IServerAttributes)context.getServer());
        } else {
            this.removeAnnotation(route);
        }
        return route;
    }

    private IRoute getRoute(IResource resource, Connection connection, IProgressMonitor monitor) {
        SubMonitor routeMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        routeMonitor.beginTask("Determine route to set the haproxy timeout for...", 2);
        if (routeMonitor.isCanceled()) {
            return null;
        }
        List<IService> services = connection.getResources("Service", resource.getNamespace());
        Collection<IService> matchingServices = ResourceUtils.getServicesFor(resource, services);
        routeMonitor.worked(1);
        if (routeMonitor.isCanceled()) {
            return null;
        }
        List routes = connection.getResources("Route", resource.getNamespace());
        Optional matchingRoute = matchingServices.stream().flatMap(service -> ResourceUtils.getRoutesFor(service, routes).stream()).findFirst();
        routeMonitor.worked(1);
        routeMonitor.done();
        return matchingRoute.orElse(null);
    }

    private void setAnnotation(String timeout, IRoute route) {
        route.setAnnotation("haproxy.router.openshift.io/timeout", timeout);
    }

    private String getAnnotation(IRoute route) {
        return route.getAnnotation("haproxy.router.openshift.io/timeout");
    }

    private void removeAnnotation(IRoute route) {
        route.removeAnnotation("haproxy.router.openshift.io/timeout");
    }
}

