/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.server.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.tools.openshift.core.server.OpenShiftServer;
import org.jboss.tools.openshift.core.server.OpenShiftServerBehaviour;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.Trace;

public class ResourceChangePublisher
implements IResourceChangeListener {
    public void resourceChanged(final IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (event.getBuildKind() == 15) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta visitorDelta) {
                    IResource resource = visitorDelta.getResource();
                    if (resource != null && resource instanceof IProject) {
                        ResourceChangePublisher.this.publishHandleProjectChange(visitorDelta, event);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            Trace.error("Error responding to resource change", e, new Object[0]);
        }
    }

    private List<IResource> getDeltaResourceChanges(IResourceDelta delta) {
        final ArrayList<IResource> changed = new ArrayList<IResource>();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta2) throws CoreException {
                if (delta2.getKind() == 0) {
                    return false;
                }
                if (delta2.getResource() instanceof IFolder && (delta2.getKind() == 1 || delta2.getKind() == 2)) {
                    changed.add(delta2.getResource());
                } else if (delta2.getResource() instanceof IFile) {
                    if (delta2.getKind() == 4 && (delta2.getFlags() & 0x20000) != 0 && (delta2.getFlags() & 0x100) == 0 && (delta2.getFlags() & 0x40000) == 0 && (delta2.getFlags() & 0x10000) == 0) {
                        return false;
                    }
                    changed.add(delta2.getResource());
                }
                return true;
            }
        };
        try {
            delta.accept(visitor);
        }
        catch (CoreException ce) {
            OpenShiftCoreActivator.logError("Could not determine the changed OpenShift resources.", ce);
        }
        return changed;
    }

    protected void publishHandleProjectChange(IResourceDelta delta, IResourceChangeEvent event) {
        IProject project = (IProject)delta.getResource();
        if (project == null) {
            return;
        }
        List<IResource> changes = this.getDeltaResourceChanges(delta);
        if (!changes.isEmpty()) {
            OpenShiftServer[] servers2 = this.getPublishRequiredServers(delta);
            int size2 = servers2.length;
            int j = 0;
            while (j < size2) {
                this.handleSpecialProjectChange(servers2[j], delta, changes, event);
                ++j;
            }
        }
    }

    private OpenShiftServer[] getPublishRequiredServers(IResourceDelta delta) {
        ArrayList<OpenShiftServer> servers2 = new ArrayList<OpenShiftServer>();
        IServer[] wrksServers = ServerCore.getServers();
        int i = 0;
        while (i < wrksServers.length) {
            IProject p;
            IProject magic;
            OpenShiftServer os = (OpenShiftServer)((Object)wrksServers[i].loadAdapter(OpenShiftServer.class, (IProgressMonitor)new NullProgressMonitor()));
            if (os != null && (magic = OpenShiftServerUtils.getDeployProject((IServerAttributes)wrksServers[i])) != null && magic.equals((Object)(p = (IProject)delta.getResource()))) {
                servers2.add(os);
            }
            ++i;
        }
        return servers2.toArray(new OpenShiftServer[servers2.size()]);
    }

    protected void handleSpecialProjectChange(OpenShiftServer server, IResourceDelta delta, List<IResource> changes, IResourceChangeEvent event) {
        Job[] jobs = Job.getJobManager().find(ServerUtil.SERVER_JOB_FAMILY);
        if (jobs != null) {
            int size = jobs.length;
            int i = 0;
            while (i < size) {
                MagicProjectChangeJob rcj;
                if (jobs[i] instanceof MagicProjectChangeJob && (rcj = (MagicProjectChangeJob)jobs[i]).getServer().equals(server.getServer()) && rcj.getState() == 2) {
                    return;
                }
                ++i;
            }
        }
        MagicProjectChangeJob job = new MagicProjectChangeJob(server, delta, changes, event);
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
    }

    public class MagicProjectChangeJob
    extends Job {
        private IResourceDelta delta;
        private OpenShiftServer openshiftServer;
        private IResourceChangeEvent event;
        private List<IResource> changes;

        public MagicProjectChangeJob(OpenShiftServer openshiftServer, IResourceDelta delta, List<IResource> change, IResourceChangeEvent event) {
            super(NLS.bind((String)Messages.jobUpdateServer, (Object)openshiftServer.getServer().getName()));
            this.openshiftServer = openshiftServer;
            this.delta = delta;
            this.changes = change;
            this.event = event;
            this.setRule(this.createResourcesRule(openshiftServer, delta));
        }

        private ISchedulingRule createResourcesRule(OpenShiftServer openshiftServer, IResourceDelta delta) {
            ISchedulingRule[] rules = new ISchedulingRule[2];
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rules[0] = ruleFactory.createRule(delta.getResource());
            rules[1] = openshiftServer.getServer();
            return MultiRule.combine((ISchedulingRule[])rules);
        }

        public boolean belongsTo(Object family) {
            return ServerUtil.SERVER_JOB_FAMILY.equals(family);
        }

        public IServer getServer() {
            return this.openshiftServer.getServer();
        }

        protected IStatus run(IProgressMonitor monitor) {
            IServer server = this.openshiftServer.getServer();
            OpenShiftServerBehaviour behaviourDelegate = (OpenShiftServerBehaviour)((Object)server.loadAdapter(OpenShiftServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor()));
            int oldState = server.getServerPublishState();
            int newState = oldState == 3 || oldState == 0 ? 3 : 2;
            ((Server)server).setServerPublishState(newState);
            if (server.getServerState() != 4 && behaviourDelegate != null) {
                behaviourDelegate.handleResourceChange();
            }
            if (server.getServerState() == 2) {
                this.autoPublish(this.event);
            }
            return Status.OK_STATUS;
        }

        private void autoPublish(IResourceChangeEvent event) {
            boolean buildOccurred = event != null && this.didBuildOccur(event);
            boolean projectClosedOrDeleted = event != null && this.isProjectCloseOrDeleteEvent(event);
            int auto = ((Server)this.openshiftServer.getServer()).getAutoPublishSetting();
            if (auto == 1) {
                return;
            }
            if (auto == 3 && !buildOccurred && !projectClosedOrDeleted) {
                return;
            }
            int time = ((Server)this.openshiftServer.getServer()).getAutoPublishTime();
            if (time >= 0) {
                this.openshiftServer.getServer().publish(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        private boolean isProjectCloseOrDeleteEvent(IResourceChangeEvent event) {
            int kind = event.getType();
            return (kind & 2) > 0 || (kind & 4) > 0;
        }

        private boolean didBuildOccur(IResourceChangeEvent event) {
            int kind = event.getBuildKind();
            boolean eventOccurred = kind == 10 || kind == 6 || kind == 9 && ResourcesPlugin.getWorkspace().isAutoBuilding();
            return eventOccurred;
        }
    }
}

