/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.util;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistryAdapter;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class NewPodDetectorJob
extends Job {
    public static final String DEPLOYMENT_CONFIG_LISTENER_JOB_TIMEOUT_KEY = "deployment.config.listener.job.timeout";
    public static final int TIMEOUT = Integer.getInteger("deployment.config.listener.job.timeout", 600000);
    private static final int SLEEP_DELAY = 100;
    private static final String POD_STATE_RUNNING = "Running";
    private IDeploymentConfig dc;
    private IPod pod;
    private Collection<String> oldPods = Collections.emptySet();
    private IConnectionsRegistryListener connectionsRegistryListener = new ConnectionsRegistryAdapter(){

        public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
            IPod notifiedPod;
            if (NewPodDetectorJob.this.pod != null) {
                return;
            }
            if (newValue instanceof IDeploymentConfig && !NewPodDetectorJob.this.dc.equals(oldValue)) {
                NewPodDetectorJob.this.dc = (IDeploymentConfig)newValue;
                return;
            }
            if (newValue instanceof IPod && this.isNewRunningRuntimePod(notifiedPod = (IPod)newValue)) {
                NewPodDetectorJob.this.pod = notifiedPod;
            }
        }

        private boolean isNewRunningRuntimePod(IPod pod) {
            return ResourceUtils.isRuntimePod(pod) && !NewPodDetectorJob.this.oldPods.contains(pod.getName()) && NewPodDetectorJob.POD_STATE_RUNNING.equals(pod.getStatus()) && ResourceUtils.areRelated(pod, (IReplicationController)NewPodDetectorJob.this.dc);
        }
    };

    public NewPodDetectorJob(IDeploymentConfig dc) {
        super("Waiting for OpenShift Pod redeployment");
        this.dc = dc;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.oldPods = this.getOldPods((IReplicationController)this.dc);
        try {
            ConnectionsRegistrySingleton.getInstance().addListener(this.connectionsRegistryListener);
            this.waitForNewPod(monitor);
            IStatus iStatus = this.pod == null ? this.getTimeOutStatus() : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            ConnectionsRegistrySingleton.getInstance().removeListener(this.connectionsRegistryListener);
        }
    }

    private Collection<String> getOldPods(IReplicationController rc) {
        Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)rc);
        List<IPod> allPods = connection.getResources("Pod", rc.getNamespace());
        return ResourceUtils.getPodsFor(rc, allPods).stream().filter(pod -> ResourceUtils.isRuntimePod(pod)).map(p -> p.getName()).collect(Collectors.toList());
    }

    private void waitForNewPod(IProgressMonitor monitor) {
        long elapsed = 0L;
        while (this.pod == null && !monitor.isCanceled() && elapsed < (long)TIMEOUT) {
            try {
                Thread.sleep(100L);
                monitor.worked(1);
                elapsed += 100L;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public IStatus getTimeOutStatus() {
        return new Status(4, "org.jboss.tools.openshift.core", "Failed to detect new deployed Pod for " + this.dc.getName());
    }

    public IPod getPod() {
        return this.pod;
    }
}

