/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.util;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IObjectReference;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.image.IImageStreamImport;
import com.openshift.restclient.model.route.IRoute;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.internal.common.core.util.KeyValueFilterFactory;

public class ResourceUtils {
    public static final String DOCKER_IMAGE_KIND = "DockerImage";
    public static final String IMAGE_STREAM_IMAGE_KIND = "ImageStreamImage";
    public static final String DEPLOYMENT_CONFIG = "deploymentconfig";

    private ResourceUtils() {
    }

    public static IClient getClient(IResource resource) {
        return (IClient)resource.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, IClient>(){

            public IClient visit(IClientCapability cap) {
                return cap.getClient();
            }
        }, null);
    }

    public static IClient checkedGetClient(IResource resource) throws CoreException {
        IClient client = ResourceUtils.getClient(resource);
        if (client == null) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not get client for resource {0}", (Object)resource.getName())));
        }
        return client;
    }

    public static boolean areRelated(IRoute route, IService service) {
        if (service != null && !StringUtils.isEmpty((String)service.getName()) && route != null) {
            return service.getName().equals(route.getServiceName());
        }
        return false;
    }

    public static boolean areRelated(IBuildConfig config, IService service) {
        if (service != null && !StringUtils.isEmpty((String)service.getName()) && config != null) {
            return service.getName().equals(config.getName());
        }
        return false;
    }

    public static boolean areRelated(IDeploymentConfig dc, IService s) {
        return ResourceUtils.containsAll(s.getSelector(), dc.getReplicaSelector());
    }

    public static boolean areRelated(IReplicationController rc, IService s) {
        return ResourceUtils.containsAll(s.getSelector(), rc.getReplicaSelector());
    }

    public static boolean areRelated(IReplicationController rc, IDeploymentConfig dc) {
        if (dc == null || rc == null) {
            return false;
        }
        return StringUtils.equals((String)dc.getName(), (String)ResourceUtils.getDeploymentConfigNameFor(rc));
    }

    public static boolean hasRelatedPods(IPod pod, List<IResource> resources) {
        return resources.stream().anyMatch(r -> "ReplicationController".equals(r.getKind()) && ResourceUtils.areRelated(pod, (IReplicationController)r));
    }

    public static boolean hasRelatedDc(IReplicationController rc, List<IResource> resources) {
        return resources.stream().anyMatch(r -> "DeploymentConfig".equals(r.getKind()) && ResourceUtils.areRelated(rc, (IDeploymentConfig)r));
    }

    public static boolean areRelated(IPod pod, IService s) {
        return ResourceUtils.containsAll(s.getSelector(), pod.getLabels());
    }

    public static boolean areRelated(IPod pod, IReplicationController rc) {
        return ResourceUtils.containsAll(rc.getReplicaSelector(), pod.getLabels());
    }

    public static Map<String, String> getMatchingLabels(KeyValueFilterFactory.KeyValueFilter filter, IResource resource) {
        Map labels = resource.getLabels();
        return labels.entrySet().stream().filter(entry -> {
            if (filter == null) {
                return true;
            }
            return filter.matchesKey((String)entry.getKey()) && filter.matchesValue((String)entry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static boolean hasMatchingLabels(KeyValueFilterFactory.KeyValueFilter filter, IResource resource) {
        Map labels = resource.getLabels();
        if (filter == null && (labels == null || labels.isEmpty())) {
            return true;
        }
        return !ResourceUtils.getMatchingLabels(filter, resource).isEmpty();
    }

    public static boolean isMatchingNameOrTag(final String filterText, final IResource resource) {
        if (resource == null || StringUtils.isBlank((String)filterText)) {
            return true;
        }
        return (Boolean)resource.accept((CapabilityVisitor)new CapabilityVisitor<ITags, Boolean>(){

            public Boolean visit(ITags capability) {
                return ResourceUtils.isMatchingNameOrTag(filterText, resource.getName(), capability.getTags());
            }
        }, (Object)Boolean.FALSE);
    }

    public static boolean isMatchingNameOrTag(String filterText, String name, Collection<String> tags) {
        if (StringUtils.isBlank((String)filterText)) {
            return true;
        }
        HashSet<String> items = new HashSet<String>(Arrays.asList(filterText.replaceAll(",", " ").toLowerCase().split(" ")));
        if (ResourceUtils.containsAll(name, items)) {
            return true;
        }
        for (String item : items) {
            if (ResourceUtils.inCollection(item, tags)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsAll(String text, Collection<String> items) {
        String _text = text.toLowerCase();
        return items.stream().allMatch(it -> _text.contains((CharSequence)it));
    }

    private static boolean inCollection(String item, Collection<String> texts) {
        String lowerCaseItem = item.toLowerCase();
        return texts.stream().anyMatch(text -> text.toLowerCase().contains(lowerCaseItem));
    }

    public static boolean containsAll(Map<String, String> source, Map<String, String> target) {
        if (source == null || target == null) {
            return false;
        }
        if (!target.keySet().isEmpty() && source.keySet().isEmpty()) {
            return false;
        }
        if (!target.keySet().containsAll(source.keySet())) {
            return false;
        }
        for (String key : source.keySet()) {
            if (Objects.deepEquals(target.get(key), source.get(key))) continue;
            return false;
        }
        return true;
    }

    public static Collection<IService> getServicesFor(IResource resource, Collection<IService> services) {
        if (resource instanceof IService) {
            return Collections.singleton((IService)resource);
        }
        if (resource instanceof IReplicationController) {
            return ResourceUtils.getServicesFor((IReplicationController)resource, services);
        }
        if (resource instanceof IPod) {
            return ResourceUtils.getServicesFor((IPod)resource, services);
        }
        return Collections.emptyList();
    }

    public static Collection<IService> getServicesFor(IPod pod, Collection<IService> services) {
        return services.stream().filter(s -> ResourceUtils.containsAll(s.getSelector(), pod.getLabels())).collect(Collectors.toSet());
    }

    public static Collection<IService> getServicesFor(IReplicationController rc, Collection<IService> services) {
        return services.stream().filter(service -> ResourceUtils.areRelated(rc, service)).collect(Collectors.toSet());
    }

    public static List<IPod> getPodsFor(IService service, List<IPod> pods) {
        Map serviceSelector = service.getSelector();
        return ResourceUtils.getPodsForSelector(serviceSelector, pods);
    }

    public static List<IPod> getPodsFor(IDeploymentConfig deploymentConfig, List<IPod> pods) {
        return pods.stream().filter(pod -> {
            String configName = pod.getAnnotation("openshift.io/deployment-config.name");
            return deploymentConfig.getName().equals(configName);
        }).collect(Collectors.toList());
    }

    public static List<IPod> getPodsFor(IResource resource, List<IPod> pods) {
        if (resource instanceof IService) {
            return ResourceUtils.getPodsFor((IService)resource, pods);
        }
        if (resource instanceof IDeploymentConfig) {
            return ResourceUtils.getPodsFor((IDeploymentConfig)resource, pods);
        }
        if (resource instanceof IReplicationController) {
            return ResourceUtils.getPodsFor((IReplicationController)resource, pods);
        }
        return Collections.emptyList();
    }

    public static Optional<IDeploymentConfig> getDeploymentConfig(IPod pod, Collection<IDeploymentConfig> deploymentConfigs) {
        return deploymentConfigs.stream().filter(dc -> dc.getName().equals(pod.getAnnotation("openshift.io/deployment-config.name"))).findFirst();
    }

    public static IReplicationController getDeploymentConfigOrReplicationControllerFor(IPod pod) {
        Optional<IDeploymentConfig> rcOrDc = ResourceUtils.getDeploymentConfig(pod, pod.getProject().getResources("DeploymentConfig"));
        if (!rcOrDc.isPresent()) {
            rcOrDc = Optional.ofNullable(ResourceUtils.getReplicationControllerFor(pod, (List<IReplicationController>)pod.getProject().getResources("ReplicationController")));
        }
        return rcOrDc.orElse(null);
    }

    private static List<IPod> getPodsForSelector(Map<String, String> serviceSelector, Collection<IPod> pods) {
        return pods.stream().filter(p -> ResourceUtils.containsAll(serviceSelector, p.getLabels())).distinct().collect(Collectors.toList());
    }

    public static boolean isBuildPod(IPod pod) {
        if (pod == null) {
            return false;
        }
        return pod.isAnnotatedWith("openshift.io/build.name");
    }

    public static Collection<IPod> getBuildPods(Collection<IPod> allPods) {
        return allPods.stream().filter(pod -> ResourceUtils.isBuildPod(pod)).collect(Collectors.toList());
    }

    public static boolean isDeployerPod(IPod pod) {
        if (pod == null) {
            return false;
        }
        return pod.getLabels().containsKey("openshift.io/deployer-pod-for.name");
    }

    public static boolean isRuntimePod(IPod pod) {
        if (pod == null) {
            return false;
        }
        return !ResourceUtils.isBuildPod(pod) && !ResourceUtils.isDeployerPod(pod);
    }

    public static Collection<IPod> getRuntimePods(Collection<IPod> allPods) {
        return allPods.stream().filter(pod -> ResourceUtils.isRuntimePod(pod)).collect(Collectors.toList());
    }

    public static String imageRef(IDeploymentImageChangeTrigger trigger) {
        block11: {
            if (trigger == null) break block11;
            switch (trigger.getKind()) {
                case "ImageStreamTag": 
                case "DockerImage": 
                case "ImageStreamImage": {
                    return trigger.getFrom().getNameAndTag();
                }
            }
        }
        return "";
    }

    public static List<String> getImageRefs(List<IBuildConfig> buildConfigs) {
        if (buildConfigs == null) {
            return null;
        }
        return buildConfigs.stream().map(bc -> ResourceUtils.imageRef(bc)).collect(Collectors.toList());
    }

    public static String imageRef(IBuildConfig config) {
        String kind;
        IObjectReference outputRef;
        if (config != null && (outputRef = config.getBuildOutputReference()) != null && ("ImageStreamTag".equals(kind = outputRef.getKind()) || IMAGE_STREAM_IMAGE_KIND.equals(kind))) {
            return outputRef.getName();
        }
        return "";
    }

    public static String imageRef(IBuild build) {
        block11: {
            if (build == null) break block11;
            switch (build.getOutputKind()) {
                case "ImageStreamTag": 
                case "DockerImage": 
                case "ImageStreamImage": {
                    return build.getOutputTo().getNameAndTag();
                }
            }
        }
        return "";
    }

    public static IResource getImageStreamTagForDigest(String digest, Collection<? extends IResource> imageStreamTags) {
        return imageStreamTags.stream().filter(istag -> {
            String imageName = ModelNode.fromJSONString((String)istag.toJson()).get("image").get("metadata").get("name").asString();
            return digest.equals(imageName);
        }).findFirst().orElse(null);
    }

    public static List<IPod> getPodsFor(IReplicationController replicationController, List<IPod> allPods) {
        Map selector = replicationController.getReplicaSelector();
        return ResourceUtils.getPodsForSelector(selector, allPods);
    }

    public static IRoute getRouteFor(IService service, Collection<IRoute> routes) {
        List<IRoute> matchingRoutes = ResourceUtils.getRoutesFor(service, routes);
        if (matchingRoutes.isEmpty()) {
            return null;
        }
        return matchingRoutes.get(0);
    }

    public static List<IRoute> getRoutesFor(IService service, Collection<IRoute> routes) {
        if (routes == null || routes.isEmpty()) {
            return Collections.emptyList();
        }
        return routes.stream().filter(r -> ResourceUtils.areRelated(r, service)).collect(Collectors.toList());
    }

    public static List<IBuildConfig> getBuildConfigsFor(IService service, List<IBuildConfig> buildConfigs) {
        if (buildConfigs == null || buildConfigs.isEmpty()) {
            return Collections.emptyList();
        }
        return buildConfigs.stream().filter(bc -> ResourceUtils.areRelated(bc, service)).collect(Collectors.toList());
    }

    public static IReplicationController getReplicationControllerFor(IService service, List<IReplicationController> allReplicationControllers) {
        if (allReplicationControllers == null || allReplicationControllers.isEmpty() || service == null) {
            return null;
        }
        List<IReplicationController> rcs = allReplicationControllers.stream().filter(rc -> ResourceUtils.containsAll(service.getSelector(), rc.getTemplateLabels())).collect(Collectors.toList());
        return ResourceUtils.getLatestDeploymentConfigVersion(rcs);
    }

    public static IReplicationController getReplicationControllerFor(IPod pod, List<IReplicationController> allReplicationControllers) {
        if (allReplicationControllers == null || allReplicationControllers.isEmpty() || pod == null) {
            return null;
        }
        return allReplicationControllers.stream().filter(rc -> ResourceUtils.containsAll(rc.getReplicaSelector(), pod.getLabels())).findFirst().orElse(null);
    }

    public static IReplicationController getLatestDeploymentConfigVersion(List<IReplicationController> rcs) {
        if (rcs == null || rcs.isEmpty()) {
            return null;
        }
        return rcs.stream().max(new NumericResourceAttributeComparator<IReplicationController>(){

            @Override
            protected int getResourceAttribute(IReplicationController rc) {
                return this.safeParseInt(rc.getAnnotation("openshift.io/deployment-config.latest-version"));
            }
        }).orElse(null);
    }

    public static boolean isOlder(IResource thisResource, IResource thatResource) {
        try {
            int thisVersion = Integer.parseInt(thisResource.getResourceVersion());
            int thatVersion = Integer.parseInt(thatResource.getResourceVersion());
            return thisVersion < thatVersion;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public static <R extends IResource> R getLatestResourceVersion(List<R> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        return (R)((IResource)resources.stream().max(new NumericResourceAttributeComparator<R>(){

            @Override
            protected int getResourceAttribute(R resource) {
                return this.safeParseInt(resource.getResourceVersion());
            }
        }).orElse(null));
    }

    public static IBuildConfig getBuildConfigFor(IService service, List<IBuildConfig> buildConfigs) {
        List<IBuildConfig> matchinBuildConfigs = ResourceUtils.getBuildConfigsFor(service, buildConfigs);
        if (matchinBuildConfigs.isEmpty()) {
            return null;
        }
        return matchinBuildConfigs.get(0);
    }

    private static IBuildConfig getBuildConfigFor(IDeploymentConfig deploymentConfig, List<IBuildConfig> buildConfigs) {
        List<IBuildConfig> matchinBuildConfigs = ResourceUtils.getBuildConfigsFor(deploymentConfig, buildConfigs);
        if (matchinBuildConfigs.isEmpty()) {
            return null;
        }
        return matchinBuildConfigs.get(0);
    }

    public static List<IBuildConfig> getBuildConfigsFor(IDeploymentConfig deploymentConfig, List<IBuildConfig> buildConfigs) {
        if (buildConfigs == null || buildConfigs.isEmpty()) {
            return Collections.emptyList();
        }
        return buildConfigs.stream().filter(bc -> ResourceUtils.areRelated(bc, deploymentConfig)).collect(Collectors.toList());
    }

    public static IBuildConfig getBuildConfigFor(IResource resource, List<IBuildConfig> buildConfigs) {
        if (resource == null) {
            return null;
        }
        if ("Service".equals(resource.getKind())) {
            return ResourceUtils.getBuildConfigFor((IService)resource, buildConfigs);
        }
        if ("DeploymentConfig".equals(resource.getKind())) {
            return ResourceUtils.getBuildConfigFor((IDeploymentConfig)resource, buildConfigs);
        }
        return null;
    }

    public static boolean areRelated(IBuildConfig config, IDeploymentConfig deploymentConfig) {
        if (deploymentConfig != null && !StringUtils.isEmpty((String)deploymentConfig.getName()) && config != null) {
            return deploymentConfig.getName().equals(config.getName());
        }
        return false;
    }

    public static boolean areRelated(IService service, IDeploymentConfig dc, Collection<IPod> allPods) {
        if (dc == null) {
            return false;
        }
        String dcName = dc.getName();
        return allPods.stream().filter(pod -> dcName.equals(pod.getAnnotation("openshift.io/deployment-config.name"))).filter(pod -> ResourceUtils.areRelated(pod, service)).count() > 0L;
    }

    public static IProject getWorkspaceProjectFor(IBuildConfig buildConfig, List<IProject> workspaceProjects) {
        if (workspaceProjects == null || workspaceProjects.isEmpty()) {
            return null;
        }
        return workspaceProjects.stream().filter(project -> EGitUtils.isSharedWithGit((IProject)project)).filter(project -> {
            try {
                if (buildConfig != null && !StringUtils.isEmpty((String)buildConfig.getSourceURI())) {
                    return EGitUtils.getAllRemoteURIs((IProject)project).contains(new URIish(buildConfig.getSourceURI()));
                }
            }
            catch (URISyntaxException | CoreException throwable) {}
            return false;
        }).findFirst().orElseGet(() -> null);
    }

    public static boolean isSuccessful(IImageStreamImport imageStreamImport) {
        return imageStreamImport.getImageStatus().stream().filter(s -> s.isSuccess()).findFirst().isPresent();
    }

    public static String getDeploymentConfigNameFor(List<IPod> pods) {
        if (pods == null || pods.isEmpty()) {
            return null;
        }
        return pods.stream().filter(pod -> !StringUtils.isBlank((String)ResourceUtils.getSelectorMatchingAny(pod.getLabels(), DEPLOYMENT_CONFIG))).findFirst().map(pod -> ResourceUtils.getDeploymentConfigNameFor(pod)).orElse(null);
    }

    public static com.openshift.restclient.model.IProject getProject(IResource resource) {
        com.openshift.restclient.model.IProject project = null;
        if (resource instanceof com.openshift.restclient.model.IProject) {
            project = (com.openshift.restclient.model.IProject)resource;
        } else if (resource != null) {
            project = resource.getProject();
        }
        return project;
    }

    private static String getDeploymentConfigNameFor(IReplicationController rc) {
        return rc.getAnnotation("openshift.io/deployment-config.name");
    }

    private static String getDeploymentConfigNameFor(IService svc) {
        return ResourceUtils.getDeploymentConfigNameFor(svc.getSelector());
    }

    private static String getDeploymentConfigNameFor(Map<String, String> selector) {
        if (MapUtils.isEmpty(selector)) {
            return null;
        }
        return ResourceUtils.getSelectorMatchingAny(selector, DEPLOYMENT_CONFIG);
    }

    public static IDeploymentConfig getDeploymentConfigFor(IResource resource, Connection connection) {
        IDeploymentConfig dc = null;
        if (resource instanceof IDeploymentConfig) {
            dc = (IDeploymentConfig)resource;
        } else if (resource instanceof IService) {
            dc = ResourceUtils.getDeploymentConfigFor((IService)resource, connection);
        } else if (resource instanceof IReplicationController) {
            dc = ResourceUtils.getDeploymentConfigFor((IReplicationController)resource, connection);
        }
        return dc;
    }

    private static IDeploymentConfig getDeploymentConfigFor(IService service, Connection connection) {
        if (service == null) {
            return null;
        }
        String dcName = ResourceUtils.getDeploymentConfigNameFor(service);
        if (dcName != null) {
            return ResourceUtils.getDeploymentConfigByName(dcName, (IResource)service, connection);
        }
        String namespace = service.getNamespace();
        IReplicationController rc = ResourceUtils.getReplicationControllerFor(service, connection.getResources("ReplicationController", namespace));
        if (rc == null) {
            return null;
        }
        List allPods = connection.getResources("Pod", namespace);
        List pods = allPods.stream().filter(pod -> ResourceUtils.areRelated(pod, rc)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pods)) {
            return null;
        }
        List dcs = connection.getResources("DeploymentConfig", namespace);
        return dcs.stream().filter(dc -> ResourceUtils.areRelated(service, dc, pods)).findFirst().orElse(null);
    }

    public static IDeploymentConfig getDeploymentConfigFor(IReplicationController rc, Connection connection) {
        String dcName = ResourceUtils.getDeploymentConfigNameFor(rc);
        if (dcName != null) {
            return ResourceUtils.getDeploymentConfigByName(dcName, (IResource)rc, connection);
        }
        List allDcs = connection.getResources("DeploymentConfig", rc.getNamespace());
        return allDcs.stream().filter(dc -> ResourceUtils.areRelated(rc, dc)).findFirst().orElse(null);
    }

    private static IDeploymentConfig getDeploymentConfigByName(String dcName, IResource resource, Connection connection) {
        if (StringUtils.isBlank((String)dcName) || resource == null) {
            return null;
        }
        return (IDeploymentConfig)connection.getResource("DeploymentConfig", resource.getNamespace(), dcName);
    }

    private static String getSelectorMatchingAny(Map<String, String> selectors, String ... keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Optional<String> matchingSelector = selectors.keySet().stream().filter(selector -> Stream.of(keys).anyMatch(key -> selector.equalsIgnoreCase((String)key))).findFirst();
        if (!matchingSelector.isPresent()) {
            return null;
        }
        return selectors.get(matchingSelector.get());
    }

    private static String getDeploymentConfigNameFor(IPod pod) {
        return ResourceUtils.getSelectorMatchingAny(pod.getLabels(), DEPLOYMENT_CONFIG);
    }

    public static IDeploymentConfig getDeploymentConfigFor(IReplicationController rc, Collection<IDeploymentConfig> dcs) {
        if (rc == null) {
            return null;
        }
        return ResourceUtils.getDeploymentConfigByName(ResourceUtils.getDeploymentConfigNameFor(rc), dcs);
    }

    private static IDeploymentConfig getDeploymentConfigByName(String name, Collection<IDeploymentConfig> dcs) {
        if (name == null || CollectionUtils.isEmpty(dcs)) {
            return null;
        }
        return dcs.stream().filter(dc -> name.equals(dc.getName())).max((Comparator<IDeploymentConfig>)new NumericResourceAttributeComparator<IDeploymentConfig>(){

            @Override
            protected int getResourceAttribute(IDeploymentConfig dc) {
                return this.safeParseInt(dc.getResourceVersion());
            }
        }).orElse(null);
    }

    public static String getProjectNameForURI(String uri) {
        String projectName = null;
        if (StringUtils.isNotEmpty((String)uri)) {
            String mangledUri = uri.trim();
            mangledUri = ResourceUtils.stripTrailingSlashes(mangledUri);
            if ((mangledUri = ResourceUtils.stripDotGit(mangledUri)) != null) {
                projectName = ResourceUtils.getLastPathSegment(mangledUri);
            }
        }
        return projectName;
    }

    private static String stripDotGit(String uri) {
        String strippedUri = uri;
        if (strippedUri.endsWith(".git") && (strippedUri = strippedUri.substring(0, strippedUri.length() - 4)).endsWith("/")) {
            return null;
        }
        return strippedUri;
    }

    private static String getLastPathSegment(String mangledUri) {
        int index = mangledUri.lastIndexOf(47);
        if (index >= 0) {
            return mangledUri.substring(index + 1);
        }
        return mangledUri;
    }

    private static String stripTrailingSlashes(String uri) {
        String strippedUri = uri;
        while (strippedUri.endsWith("/")) {
            strippedUri = strippedUri.substring(0, strippedUri.length() - 1);
        }
        return strippedUri;
    }

    private static abstract class NumericResourceAttributeComparator<R>
    implements Comparator<R> {
        private NumericResourceAttributeComparator() {
        }

        @Override
        public int compare(R r1, R r2) {
            int attr2;
            if (r1 == null) {
                if (r2 == null) {
                    return 0;
                }
                return 1;
            }
            if (r2 == null) {
                return -1;
            }
            int attr1 = this.getResourceAttribute(r1);
            if (attr1 < (attr2 = this.getResourceAttribute(r2))) {
                return -1;
            }
            if (attr1 == attr2) {
                return 0;
            }
            return 1;
        }

        protected abstract int getResourceAttribute(R var1);

        protected int safeParseInt(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }
}

