/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;
import org.jboss.tools.openshift.internal.ui.handler.OpenInWebBrowserHandler;
import org.jboss.tools.openshift.internal.ui.handler.SelectedRoutePreference;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;

public class EditDefaultRouteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection currentSelection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        final IServiceWrapper service = (IServiceWrapper)UIUtils.getFirstElement((ISelection)currentSelection, IServiceWrapper.class);
        if (service != null) {
            new RouteOpenerJob(this, ((IService)service.getWrapped()).getNamespace(), shell){

                protected IStatus run(IProgressMonitor monitor) {
                    this.routes = service.getResourcesOfKind("Route").stream().map(r -> (IRoute)r.getWrapped()).collect(Collectors.toList());
                    return Status.OK_STATUS;
                }
            }.schedule();
            return Status.OK_STATUS;
        }
        final IProject project = (IProject)UIUtils.getFirstElement((ISelection)currentSelection, IProject.class);
        if (project != null) {
            new RouteOpenerJob(this, project.getName(), shell){

                protected IStatus run(IProgressMonitor monitor) {
                    this.routes = project.getResources("Route");
                    return Status.OK_STATUS;
                }
            }.schedule();
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }

    private abstract class RouteOpenerJob
    extends UIUpdatingJob {
        protected List<IRoute> routes;
        private Shell shell;

        public RouteOpenerJob(String projectName, Shell shell) {
            super(NLS.bind((String)"Loading routes for project {0}", (Object)projectName));
            this.shell = shell;
        }

        protected IStatus updateUI(IProgressMonitor monitor) {
            if (this.routes == null || this.routes.isEmpty()) {
                return OpenInWebBrowserHandler.nothingToOpenDialog(this.shell);
            }
            IRoute selectedRoute = SelectedRoutePreference.instance.getSelectedRoute(this.routes);
            SelectRouteDialog routeDialog = new SelectRouteDialog(this.routes, this.shell, selectedRoute != null, selectedRoute);
            if (routeDialog.open() == 0) {
                selectedRoute = routeDialog.getSelectedRoute();
                if (routeDialog.isRememberChoice()) {
                    SelectedRoutePreference.instance.setSelectedRoute(this.routes, selectedRoute);
                } else {
                    SelectedRoutePreference.instance.removeSelectedRoute(this.routes);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

