/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.handler.OpenInWebBrowserHandler;
import org.jboss.tools.openshift.internal.ui.property.OpenShiftResourceInput;

public class EditResourceHandler
extends OpenInWebBrowserHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IResource resource = (IResource)UIUtils.getFirstElement((ISelection)currentSelection, IResource.class);
        Connection connection = null;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (resource == null) {
            MessageDialog.openWarning((Shell)shell, (String)"Nothing to edit", (String)"This is not the resource you are looking for.");
            return null;
        }
        connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource);
        if (connection != null) {
            IWorkbenchWindow win = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            try {
                this.openInEditor(win, connection, resource);
            }
            catch (PartInitException e) {
                String msg = NLS.bind((String)"Error opening {0} : \"{1}\" in editor: {2}", (Object[])new String[]{resource.getKind(), resource.getName(), e.getMessage()});
                OpenShiftUIActivator.getDefault().getLogger().logError(msg, (Throwable)e);
            }
        }
        return null;
    }

    private void openInEditor(IWorkbenchWindow window, Connection connection, IResource resource) throws PartInitException {
        OpenShiftResourceInput input = new OpenShiftResourceInput(connection, resource);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            String defaultJsonEditorId = this.getDefaultJSONEditorDescriptorId(editorRegistry);
            page.openEditor((IEditorInput)input, defaultJsonEditorId);
        }
    }

    private String getDefaultJSONEditorDescriptorId(IEditorRegistry editorRegistry) {
        return editorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor").getId();
    }
}

