/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IDeployCapability;
import com.openshift.restclient.model.IDeploymentConfig;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.comparators.CreationTimestampComparator;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;

public class TriggerDeploymentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IDeploymentConfig resource = this.retrieveDeploymentConfig(selection);
        if (resource == null) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Trigger Deployment", (String)"A deployment or deployment config must be selected in order to trigger a new deployment.");
            return null;
        }
        this.scheduleJob(resource);
        return null;
    }

    private IDeploymentConfig retrieveDeploymentConfig(ISelection selection) {
        IServiceWrapper deployment = (IServiceWrapper)UIUtils.getFirstElement((ISelection)selection, IServiceWrapper.class);
        if (deployment != null) {
            Collection configs = deployment.getResourcesOfKind("DeploymentConfig");
            if (!configs.isEmpty()) {
                if (configs.size() == 1) {
                    return (IDeploymentConfig)((IResourceWrapper)configs.iterator().next()).getWrapped();
                }
                return (IDeploymentConfig)configs.stream().sorted(new CreationTimestampComparator()).collect(Collectors.toList()).get(0);
            }
            return null;
        }
        return (IDeploymentConfig)UIUtils.getFirstElement((ISelection)selection, IDeploymentConfig.class);
    }

    private void scheduleJob(final IDeploymentConfig resource) {
        new AbstractDelegatingMonitorJob("Starting new OpenShift deployment..."){

            protected IStatus doRun(IProgressMonitor monitor) {
                return (IStatus)resource.accept((CapabilityVisitor)new CapabilityVisitor<IDeployCapability, IStatus>(){

                    public IStatus visit(IDeployCapability cap) {
                        try {
                            cap.deploy();
                        }
                        catch (OpenShiftException e) {
                            return new Status(4, "org.jboss.tools.openshift.ui", NLS.bind((String)"Unable to perform a deployment for config {0}", (Object)resource.getName()), (Throwable)e);
                        }
                        return new Status(0, "org.jboss.tools.openshift.ui", NLS.bind((String)"Deployment triggered for config {0}", (Object)resource.getName()));
                    }
                }, (Object)Status.OK_STATUS);
            }
        }.schedule();
    }
}

