/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.internal.core.OCBinaryOperation;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class PodLogsJob
extends AbstractDelegatingMonitorJob {
    private static final String DOCUMENT_IS_CLOSED = "Document is closed";
    private static final Map<Key, ConsoleStreamPipe> REGISTRY = new HashMap<Key, ConsoleStreamPipe>();
    private final Key key;

    public PodLogsJob(IPod pod, String containerName) {
        super("FollowPodLogsJob");
        this.key = new Key(pod, containerName);
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            monitor.worked(-1);
            if (REGISTRY.containsKey(this.key)) {
                this.showConsole();
            } else {
                ConsoleStreamPipe pipe = (ConsoleStreamPipe)this.key.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPodLogRetrieval, ConsoleStreamPipe>(){

                    public ConsoleStreamPipe visit(IPodLogRetrieval capability) {
                        Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)((PodLogsJob)PodLogsJob.this).key.pod);
                        ConsoleStreamPipe consoleStream = new ConsoleStreamPipe(capability, connection);
                        new Thread(consoleStream).start();
                        return consoleStream;
                    }
                }, null);
                if (pipe != null) {
                    REGISTRY.put(this.key, pipe);
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private MessageConsole showConsole() {
        MessageConsole console = ConsoleUtils.findMessageConsole((String)this.getMessageConsoleName());
        ConsoleUtils.displayConsoleView((IConsole)console);
        return console;
    }

    private String getMessageConsoleName() {
        IPod pod = this.key.pod;
        return NLS.bind((String)"{0}\\{1}\\{2} log", (Object[])new Object[]{pod.getNamespace(), pod.getName(), this.key.container});
    }

    private int readSafely(InputStream logs, byte[] data) throws IOException {
        try {
            if (logs.available() < 0) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        try {
            return logs.read(data);
        }
        catch (IOException e) {
            if ("Stream closed".equals(e.getMessage())) {
                return -1;
            }
            throw e;
        }
    }

    static /* synthetic */ MessageConsole access$0(PodLogsJob podLogsJob) {
        return podLogsJob.showConsole();
    }

    static /* synthetic */ int access$2(PodLogsJob podLogsJob, InputStream inputStream, byte[] byArray) throws IOException {
        return podLogsJob.readSafely(inputStream, byArray);
    }

    private class ConsoleListener
    implements IConsoleListener {
        private ConsoleStreamPipe pipe;

        protected ConsoleListener(ConsoleStreamPipe pipe) {
            this.pipe = pipe;
        }

        public void consolesRemoved(IConsole[] consoles) {
            String messageConsoleName = PodLogsJob.this.getMessageConsoleName();
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals(messageConsoleName)) {
                    try {
                        this.pipe.stop();
                        REGISTRY.remove(PodLogsJob.this.key);
                        return;
                    }
                    finally {
                        ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                    }
                }
                ++n2;
            }
        }

        public void consolesAdded(IConsole[] consoles) {
        }
    }

    private class ConsoleStreamPipe
    extends OCBinaryOperation
    implements Runnable {
        private IPodLogRetrieval capability;
        private boolean running = true;
        private Connection connection;

        ConsoleStreamPipe(IPodLogRetrieval capability, Connection connection) {
            this.capability = capability;
            this.connection = connection;
        }

        public void stop() {
            this.running = false;
            this.capability.stop();
        }

        @Override
        public void run() {
            this.run((IConnection)this.connection, null);
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void runOCBinary(MultiStatus multiStatus) {
            ConsoleUtils.registerConsoleListener((IConsoleListener)new ConsoleListener(this));
            console = PodLogsJob.access$0(PodLogsJob.this);
            os = console.newMessageStream();
            os.setEncoding("UTF-8");
            try {
                try {
                    logs = this.capability.getLogs(true, PodLogsJob.access$1((PodLogsJob)PodLogsJob.this).container, new IBinaryCapability.OpenShiftBinaryOption[]{IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY});
                    data = new byte[256];
                    read = 0;
                    if (true) ** GOTO lbl13
                    do {
                        os.write(data, 0, read);
lbl13:
                        // 2 sources

                        if (!this.running || (read = PodLogsJob.access$2(PodLogsJob.this, logs, data)) == -1) return;
                    } while (!os.isClosed());
                    return;
                }
                catch (OpenShiftException e) {
                    OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                    try {
                        if (os != null) {
                            os.write(e.getMessage().getBytes());
                        }
                    }
                    catch (IOException e1) {
                        OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e1);
                    }
                    try {
                        if (os == null) return;
                        os.close();
                        return;
                    }
                    catch (IOException e) {
                        OpenShiftUIActivator.getDefault().getLogger().logError("Exception while closing pod log inputstream", (Throwable)e);
                    }
                    return;
                }
                catch (IOException e) {
                    block23: {
                        if ("Document is closed".equals(e.getMessage())) break block23;
                        OpenShiftUIActivator.getDefault().getLogger().logError("Exception reading pod log inputstream", (Throwable)e);
                    }
                    try {
                        if (os == null) return;
                        os.close();
                        return;
                    }
                    catch (IOException e) {
                        OpenShiftUIActivator.getDefault().getLogger().logError("Exception while closing pod log inputstream", (Throwable)e);
                    }
                    return;
                }
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    OpenShiftUIActivator.getDefault().getLogger().logError("Exception while closing pod log inputstream", (Throwable)e);
                }
            }
        }
    }

    private static class Key {
        final IPod pod;
        final String container;

        Key(IPod pod, String containerName) {
            this.pod = pod;
            this.container = containerName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
            result = 31 * result + (this.pod == null ? 0 : this.pod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
                return false;
            }
            return !(this.pod == null ? other.pod != null : !this.pod.equals(other.pod));
        }
    }
}

