/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.tools.openshift.internal.core.Trace;

class ResourceCache {
    private Map<String, Map<String, IResource>> cache = new HashMap<String, Map<String, IResource>>();

    ResourceCache() {
    }

    public void dispose() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String namespace) {
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            this.cache.remove(namespace);
        }
    }

    private String getCacheKey(IResource resource) {
        return this.getCacheKey(resource.getKind(), resource.getName());
    }

    private String getCacheKey(String kind, String name) {
        return String.valueOf(kind) + "/" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IResource> T getResource(String namespace, String kind, String name) {
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            Map<String, IResource> projectResources = this.cache.get(namespace);
            if (projectResources != null) {
                return (T)projectResources.get(this.getCacheKey(kind, name));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IResource> Collection<T> getResources(String namespace, String kind) {
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            Map<String, IResource> projectResources = this.cache.get(namespace);
            if (projectResources != null) {
                return projectResources.values().stream().filter(r -> kind.equals(r.getKind())).map(r -> r).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IResource> Collection<T> getResources(String namespace) {
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            Map<String, IResource> projectResources = this.cache.get(namespace);
            if (projectResources != null) {
                return new ArrayList<IResource>(projectResources.values());
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IResource resource) {
        if (resource == null) {
            return false;
        }
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            block5: {
                if (this.getCachedVersion(resource) == null) break block5;
                Trace.debug((String)"-->Returning early since already processed {0}", (Object[])new Object[]{resource});
                return false;
            }
            this.putIntoCache(resource);
        }
        return true;
    }

    private void removeFromCache(IResource resource) {
        Map<String, IResource> projectResources = this.cache.get(this.getNamespace(resource));
        if (projectResources != null) {
            projectResources.remove(this.getCacheKey(resource));
            if (projectResources.isEmpty()) {
                this.cache.remove(this.getNamespace(resource));
            }
        }
    }

    private void putIntoCache(IResource resource) {
        Map<String, IResource> projectResources = this.cache.get(this.getNamespace(resource));
        if (projectResources == null) {
            projectResources = new HashMap<String, IResource>();
            this.cache.put(this.getNamespace(resource), projectResources);
        }
        projectResources.put(this.getCacheKey(resource), resource);
    }

    public String getNamespace(IResource resource) {
        return resource.getNamespace();
    }

    public IResource getCachedVersion(IResource resource) {
        return this.getResource(this.getNamespace(resource), resource.getKind(), resource.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IResource resource) {
        if (resource == null) {
            return false;
        }
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            this.removeFromCache(resource);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(IResource resource) {
        if (resource == null) {
            return false;
        }
        Map<String, Map<String, IResource>> map = this.cache;
        synchronized (map) {
            block5: {
                if (!this.isUpToDate(resource)) break block5;
                Trace.debug((String)"-->Returning early since already have this change: {0}", (Object[])new Object[]{resource});
                return false;
            }
            this.putIntoCache(resource);
        }
        return true;
    }

    public boolean isUpToDate(IResource resource) {
        IResource cachedVersion = this.getCachedVersion(resource);
        return cachedVersion != null && Integer.parseInt(cachedVersion.getResourceVersion()) >= Integer.parseInt(resource.getResourceVersion());
    }
}

