/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.portforwading;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.resources.IPortForwardable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.core.portforwarding.PortForwardingUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.portforwading.PortForwardingWizard;
import org.jboss.tools.openshift.internal.ui.portforwading.PortForwardingWizardModel;

public class PortForwardingWizardPage
extends AbstractOpenShiftWizardPage {
    private static final IPluginLog LOG = OpenShiftUIActivator.getDefault().getLogger();
    private final PortForwardingWizardModel wizardModel;
    StyledString.Styler usedPortStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = Display.getDefault().getSystemColor(3);
        }
    };

    public PortForwardingWizardPage(PortForwardingWizardModel wizardModel, PortForwardingWizard portForwardingWizard) {
        super("Port forwarding", null, "PortForwardingWizardPage", (IWizard)portForwardingWizard);
        this.wizardModel = wizardModel;
        this.setDescription(NLS.bind((String)"Port forwarding for the {0} pod.", (Object)wizardModel.getPodName()));
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(parent);
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        Composite tableContainer = new Composite(container, 0);
        final TableViewer viewer = this.createTable(tableContainer, dbc);
        GridDataFactory.fillDefaults().span(1, 3).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        Button startButton = new Button(container, 8);
        startButton.setText("Start All");
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)startButton);
        startButton.addSelectionListener(this.onStartPortForwarding(viewer));
        Button stopButton = new Button(container, 8);
        stopButton.setText("Stop All");
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)stopButton);
        stopButton.addSelectionListener(this.onStopPortForwarding(viewer));
        Button findFreesPortButton = new Button(container, 32);
        findFreesPortButton.setText("Find free local ports for remote ports");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(false, false).applyTo((Control)findFreesPortButton);
        IObservableValue findFreePortsButtonObservable = BeanProperties.value((String)"useFreePorts").observe((Object)this.wizardModel);
        ISWTObservableValue findFreePortsButtonSelection = WidgetProperties.selection().observe((Widget)findFreesPortButton);
        dbc.bindValue((IObservableValue)findFreePortsButtonSelection, findFreePortsButtonObservable);
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                PortForwardingWizardPage.this.refreshViewerInput(viewer);
            }
        }, (IObservableValue)findFreePortsButtonObservable, (Control)viewer.getTable());
        IObservableValue portForwardingStartedObservable = BeanProperties.value((String)"portForwarding").observe((Object)this.wizardModel);
        IObservableValue portForwardingAllowedObservable = BeanProperties.value((String)"portForwardingAllowed").observe((Object)this.wizardModel);
        IObservableValue freePortSearchAllowedObservable = BeanProperties.value((String)"freePortSearchAllowed").observe((Object)this.wizardModel);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)startButton)).notUpdating(portForwardingAllowedObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)stopButton)).notUpdating(portForwardingStartedObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)findFreesPortButton)).notUpdating(freePortSearchAllowedObservable).in(dbc);
    }

    private SelectionListener onStartPortForwarding(final TableViewer viewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PortForwardingWizardPage.this.wizardModel.checkPortForwardingAllowed()) {
                    viewer.refresh(true);
                    MessageDialog.openWarning((Shell)PortForwardingWizardPage.this.getShell(), (String)"Warning", (String)"Some ports are in use now.");
                    return;
                }
                try {
                    WizardUtils.runInWizard((Job)new Job("Starting port forwarding..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            PortForwardingWizardPage.this.wizardModel.startPortForwarding();
                            PortForwardingWizardPage.this.refreshViewerInput(viewer);
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)PortForwardingWizardPage.this.getContainer(), (DataBindingContext)PortForwardingWizardPage.this.getDataBindingContext());
                }
                catch (OpenShiftException | InterruptedException | InvocationTargetException e1) {
                    LOG.logError(e1);
                    MessageDialog.openError((Shell)PortForwardingWizardPage.this.getShell(), (String)"Error starting port forwarding", (String)e1.getMessage());
                }
            }
        };
    }

    private SelectionListener onStopPortForwarding(final TableViewer viewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new Job("Stopping port forwarding..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                PortForwardingWizardPage.this.wizardModel.stopPortForwarding();
                            }
                            catch (IOException e) {
                                Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Failed to close console inputstream while stopping port-forwarding: " + e.getMessage())));
                                OpenShiftUIActivator.getDefault().getLogger().logError("Failed to close console inputstream while stopping port-forwarding", (Throwable)e);
                            }
                            PortForwardingWizardPage.this.refreshViewerInput(viewer);
                            if (!PortForwardingWizardPage.this.wizardModel.isPortForwardingAllowed()) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        PortForwardingWizardPage.this.waitForPortsToGetFree(viewer);
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)PortForwardingWizardPage.this.getContainer(), (DataBindingContext)PortForwardingWizardPage.this.getDataBindingContext());
                }
                catch (OpenShiftException | InterruptedException | InvocationTargetException e1) {
                    LOG.logError(e1);
                    MessageDialog.openError((Shell)PortForwardingWizardPage.this.getShell(), (String)"Error stopping port forwarding", (String)e1.getMessage());
                }
            }
        };
    }

    private void waitForPortsToGetFree(final TableViewer viewer) {
        if (this.wizardModel.waitForPortsToGetFree(0)) {
            return;
        }
        try {
            WizardUtils.runInWizard((Job)new Job("Waiting for ports to get free..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!PortForwardingWizardPage.this.wizardModel.waitForPortsToGetFree(5)) {
                        Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)"Ports remain in use. Try free ports."));
                    }
                    PortForwardingWizardPage.this.refreshViewerInput(viewer);
                    return Status.OK_STATUS;
                }
            }, (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
        }
        catch (InterruptedException | InvocationTargetException e1) {
            LOG.logError((Throwable)e1);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error while waiting for ports to get free", (String)e1.getMessage());
        }
    }

    protected TableViewer createTable(Composite tableContainer, DataBindingContext dbc) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableColumn("Name", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IPortForwardable.PortPair port = (IPortForwardable.PortPair)cell.getElement();
                cell.setText(StringUtils.defaultIfBlank((String)port.getName(), (String)""));
            }
        }, viewer, tableLayout);
        this.createTableColumn("Local Port", 2, (CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IPortForwardable.PortPair port = (IPortForwardable.PortPair)cell.getElement();
                int local = port.getLocalPort();
                if (PortForwardingWizardPage.this.wizardModel.getPortForwarding() || !PortForwardingUtils.isPortInUse((int)local)) {
                    cell.setText(Integer.toString(local));
                    cell.setStyleRanges(new StyleRange[0]);
                } else {
                    String text = String.valueOf(Integer.toString(local)) + " (in use)";
                    StyledString styledString = new StyledString();
                    styledString.append(text, PortForwardingWizardPage.this.usedPortStyler);
                    cell.setText(styledString.toString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                }
                super.update(cell);
            }
        }, viewer, tableLayout);
        this.createTableColumn("Remote Port", 2, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IPortForwardable.PortPair port = (IPortForwardable.PortPair)cell.getElement();
                cell.setText(Integer.toString(port.getRemotePort()));
            }
        }, viewer, tableLayout);
        this.createTableColumn("Status", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                boolean started = PortForwardingWizardPage.this.wizardModel.getPortForwarding();
                cell.setText(started ? "Started" : "Stopped");
            }
        }, viewer, tableLayout);
        IObservableValue forwardablePortsModelObservable = BeanProperties.value((String)"forwardablePorts").observe((Object)this.wizardModel);
        ForwardablePortListValidator validator = new ForwardablePortListValidator(forwardablePortsModelObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        viewer.setInput(this.wizardModel.getForwardablePorts());
        return viewer;
    }

    private void createTableColumn(String name, int weight, CellLabelProvider cellLabelProvider, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(name);
        column.setLabelProvider(cellLabelProvider);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    private void refreshViewerInput(final TableViewer viewer) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    viewer.setInput(PortForwardingWizardPage.this.wizardModel.getForwardablePorts());
                }
                catch (Exception e) {
                    LOG.logError("Failed to refresh table content with list of ports for selected pod", (Throwable)e);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return true;
    }

    public void dispose() {
        if (!this.wizardModel.getPortForwarding()) {
            this.wizardModel.setUseFreePorts(false);
        }
        super.dispose();
    }

    class ForwardablePortListValidator
    extends MultiValidator {
        private final IObservableValue viewerObservable;

        public ForwardablePortListValidator(IObservableValue viewerObservable) {
            this.viewerObservable = viewerObservable;
        }

        protected IStatus validate() {
            Collection ports = (Collection)this.viewerObservable.getValue();
            if (ports == null || ports.isEmpty()) {
                return ValidationStatus.error((String)NLS.bind((String)"There are no available ports to forward to {0}.\nYour pod may not be running or does not expose any ports.", (Object)PortForwardingWizardPage.this.wizardModel.getPodName()));
            }
            return Status.OK_STATUS;
        }
    }
}

