/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistryAdapter;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.DismissableNagDialog;
import org.jboss.tools.openshift.internal.ui.property.OpenShiftResourceInput;

public class OpenShiftResourceDocumentProvider
extends AbstractDocumentProvider {
    private WorkspaceOperationRunner operationRunner;
    private Map<OpenShiftResourceInput, ConnectionListener> inputToListeners = new HashMap<OpenShiftResourceInput, ConnectionListener>();

    protected IDocument createDocument(Object element) throws CoreException {
        OpenShiftResourceInput input = this.getInput(element);
        Document document = null;
        if (input != null) {
            IResource resource = input.getResource();
            document = new Document(resource.toJson());
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        OpenShiftResourceInput input = this.getInput(element);
        if (input != null) {
            Map<OpenShiftResourceInput, ConnectionListener> map = this.inputToListeners;
            synchronized (map) {
                ConnectionListener listener = new ConnectionListener(input, this);
                this.addElementStateListener(listener);
                ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)listener);
                this.inputToListeners.put(input, listener);
            }
        }
        return super.createElementInfo(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        OpenShiftResourceInput input = this.getInput(element);
        if (input != null) {
            Map<OpenShiftResourceInput, ConnectionListener> map = this.inputToListeners;
            synchronized (map) {
                ConnectionListener listener = this.inputToListeners.remove(input);
                if (listener != null) {
                    ConnectionsRegistrySingleton.getInstance().removeListener((IConnectionsRegistryListener)listener);
                    this.removeElementStateListener(listener);
                }
            }
        }
        super.disposeElementInfo(element, info);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, final Object element, IDocument document, boolean overwrite) throws CoreException {
        OpenShiftResourceInput input = this.getInput(element);
        if (input == null) {
            return;
        }
        final IResource resource = input.getResource();
        final IClient client = ResourceUtils.getClient((IResource)resource);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        Connection connection = input.getConnection();
        final String resourceName = input.getName();
        final IResource newResource = connection.getResourceFactory().create(document.get());
        final Exception[] exceptions = new Exception[1];
        Job updateResourceJob = new Job("Update " + resourceName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    client.update(newResource);
                }
                catch (Exception e) {
                    OpenShiftException oe;
                    exceptions[0] = e;
                    Display.getDefault().asyncExec(() -> OpenShiftResourceDocumentProvider.this.setDirty(element));
                    String problem = e.getMessage();
                    if (e instanceof OpenShiftException && (oe = (OpenShiftException)((Object)e)).getStatus() != null) {
                        problem = oe.getStatus().getMessage();
                    }
                    IStatus error = OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not update \"{0}\" for project \"{1}\" : {2}", (Object[])new String[]{resourceName, resource.getNamespace(), problem}), (Throwable)e);
                    return error;
                }
                return Status.OK_STATUS;
            }
        };
        updateResourceJob.schedule();
        Shell shell = Display.getCurrent().getActiveShell();
        service.showInDialog(shell, updateResourceJob);
        if (exceptions[0] != null) {
            throw new CoreException(OpenShiftUIActivator.statusFactory().errorStatus((Throwable)exceptions[0]));
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.operationRunner == null) {
            this.operationRunner = new WorkspaceOperationRunner();
        }
        this.operationRunner.setProgressMonitor(monitor);
        return this.operationRunner;
    }

    private OpenShiftResourceInput getInput(Object o) {
        return o instanceof OpenShiftResourceInput ? (OpenShiftResourceInput)o : null;
    }

    public boolean isReadOnly(Object element) {
        return this.getInput(element) == null;
    }

    public boolean isModifiable(Object element) {
        return this.getInput(element) != null;
    }

    private void setDirty(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo != null) {
            elementInfo.fCanBeSaved = true;
            this.fireElementDirtyStateChanged(element, true);
        }
    }

    private static class ConnectionListener
    extends ConnectionsRegistryAdapter
    implements IElementStateListener {
        private final OpenShiftResourceInput input;
        private final OpenShiftResourceDocumentProvider provider;
        private AtomicBoolean dirty = new AtomicBoolean(false);
        private AtomicBoolean nag = new AtomicBoolean(true);
        private static final String NAG_MESSAGE = "The resource {0} has been changed on the server.  Do you want to replace the editor contents with these changes.";
        private DismissableNagDialog dialog;
        private AtomicReference<IResource> resource = new AtomicReference();

        ConnectionListener(OpenShiftResourceInput input, OpenShiftResourceDocumentProvider provider) {
            this.input = input;
            this.provider = provider;
            this.dialog = new DismissableNagDialog(UIUtils.getShell(), "File Changed", NLS.bind((String)NAG_MESSAGE, (Object)input.getResource().getName()));
            this.resource.set(input.getResource());
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            this.dirty.set(isDirty);
        }

        public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
            if (!"openshift.resource".equals(property)) {
                return;
            }
            if (this.input.getConnection() == null || !this.input.getConnection().equals((Object)connection)) {
                return;
            }
            if (oldValue == null || newValue == null) {
                return;
            }
            IResource resource = (IResource)newValue;
            if (!this.resource.get().equals(resource)) {
                return;
            }
            this.resource.set(resource);
            if (this.dialog.isOpen()) {
                return;
            }
            this.updateEditor();
        }

        private void updateEditor() {
            Display.getDefault().asyncExec(() -> {
                if (!this.dirty.get()) {
                    this.updateEditor(this.resource.get());
                } else if (this.nag.get()) {
                    switch (this.dialog.open()) {
                        case 0: {
                            this.nag.set(false);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            return;
                        }
                    }
                }
                this.updateEditor(this.resource.get());
            });
        }

        private void updateEditor(IResource resource) {
            this.input.setResource(resource);
            try {
                this.provider.resetDocument(this.input);
            }
            catch (Exception e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                this.provider.setDirty(this.input);
                throw new RuntimeException(e);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    }
}

