/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.ui.server.ChooseOpenshiftConnectionComposite;
import org.jboss.tools.openshift.internal.ui.server.OpenShiftServerTaskModelAccessor;

public class ChooseOpenshiftConnectionFragment
extends WizardFragment {
    private IWizardHandle handle;
    private ChooseOpenshiftConnectionComposite chooseConnectionComposite;
    private PropertyChangeListener externalConnectionListener;
    private IConnection selectedConnection;

    protected void initWizardHandle() {
        this.handle.setTitle("Choose an OpenShift Connection");
        this.handle.setDescription("Please choose an openshift connection to use for this server adapter.");
        this.handle.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.chooseConnectionComposite != null && !this.chooseConnectionComposite.isDisposed() && super.isComplete();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.initWizardHandle();
        this.chooseConnectionComposite = new ChooseOpenshiftConnectionComposite(parent);
        this.chooseConnectionComposite.setConnectionChangeListener(new ChooseOpenshiftConnectionComposite.IConnectionChangedListener(){

            @Override
            public void connectionChanged(IConnection newVal) {
                ChooseOpenshiftConnectionFragment.this.selectedConnectionChanged(newVal);
            }
        });
        this.getContainer(this.getPage(handle)).addPageChangingListener(this.onPageChanging(handle));
        this.selectedConnectionChanged(this.chooseConnectionComposite.getConnection());
        return this.chooseConnectionComposite;
    }

    private void selectedConnectionChanged(IConnection newVal) {
        IConnection oldCon = this.selectedConnection;
        this.selectedConnection = newVal;
        this.setComplete(this.selectedConnection != null);
        this.handle.update();
        if (this.externalConnectionListener != null) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "selectedConnection", oldCon, this.selectedConnection);
            this.externalConnectionListener.propertyChange(event);
        }
    }

    private IWizardPage getPage(IWizardHandle wizardHandle) {
        return (IWizardPage)wizardHandle;
    }

    private WizardDialog getContainer(IWizardPage wizardPage) {
        return (WizardDialog)wizardPage.getWizard().getContainer();
    }

    public void addConnectionChangeListener(PropertyChangeListener connectionChangeListener) {
        this.externalConnectionListener = connectionChangeListener;
    }

    private IPageChangingListener onPageChanging(final IWizardHandle wizardHandle) {
        return new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getCurrentPage() == ChooseOpenshiftConnectionFragment.this.getPage(wizardHandle)) {
                    if (event.getTargetPage() == null || event.getTargetPage().equals(ChooseOpenshiftConnectionFragment.this.getPage(wizardHandle).getNextPage())) {
                        String blockedMsg = null;
                        try {
                            blockedMsg = ChooseOpenshiftConnectionFragment.this.runConnectionJob();
                        }
                        catch (Exception e) {
                            blockedMsg = "Error while checking if we can connect to OpenShift Connection: " + e.getMessage();
                        }
                        event.doit = blockedMsg == null;
                        ChooseOpenshiftConnectionFragment.this.handle.setMessage(blockedMsg, blockedMsg == null ? 0 : 3);
                    }
                    if (ChooseOpenshiftConnectionFragment.this.selectedConnection instanceof Connection) {
                        OpenShiftServerTaskModelAccessor.set((Connection)ChooseOpenshiftConnectionFragment.this.selectedConnection, ChooseOpenshiftConnectionFragment.this.getTaskModel());
                    }
                }
            }
        };
    }

    private String runConnectionJob() throws Exception {
        String blockedMsg = null;
        if (this.selectedConnection != null && this.selectedConnection.canConnect()) {
            Job connectJob = this.chooseConnectionComposite.getConnectJob();
            WizardUtils.runInWizard((Job)connectJob, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer((IWizardPage)((WizardPage)this.handle)));
            boolean connected = JobUtils.isOk((IStatus)connectJob.getResult());
            if (!connected) {
                blockedMsg = connectJob.getResult().getMessage();
            }
            return blockedMsg;
        }
        return blockedMsg;
    }
}

