/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;
import org.jboss.tools.foundation.ui.jobs.DisableAllWidgetsJob;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.FormEditorPresenter;
import org.jboss.tools.openshift.internal.common.ui.databinding.FormPresenterSupport;
import org.jboss.tools.openshift.internal.common.ui.databinding.NumericValidator;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.ui.validator.OpenShiftIdentifierValidator;

public class OpenShiftServerEditorSection
extends ServerEditorSection {
    private IServerEditorPartInput input;
    private DataBindingContext dbc;
    private FormPresenterSupport formPresenterSupport;
    private InitialModel initialModel;
    private Text currentConnectionText;
    private Text projectText;
    private Text sourcePathText;
    private Label resourceKindLabel;
    private Text resourceText;
    private Text deployPathText;
    private Text devmodeKeyText;
    private Text debugPortText;
    private Text debugPortKeyText;
    private Button useImageDebugPortKeyButton;
    private ModifyListener deployPathModifyListener;
    private ModifyListener devmodeKeyModifyListener;
    private ModifyListener debugPortKeyListener;
    private ModifyListener debugPortValListener;
    private SelectionListener debugPortKeyValSelectionListener;
    private SelectionAdapter useImageDevmodeKeyListener;
    private Button useImageDevmodeKeyButton;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (input instanceof IServerEditorPartInput) {
            this.input = (IServerEditorPartInput)input;
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.dbc = new DataBindingContext();
        this.formPresenterSupport = new FormPresenterSupport((FormPresenterSupport.IFormPresenter)new FormEditorPresenter(this.getManagedForm().getForm().getForm()), this.dbc);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText("OpenShift Server Adapter");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)section);
        Composite container = this.createControls(toolkit, (Composite)section, this.dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        toolkit.paintBordersFor(container);
        toolkit.adapt(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        section.setClient((Control)container);
        this.setupWarningToRestartAdapter((IEditorPart)this.getServerEditor());
        this.loadResources((Composite)section, this.dbc);
        this.dbc.updateTargets();
    }

    private Composite createControls(FormToolkit toolkit, Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        this.createConnectionContols(container, dbc);
        this.createEclipseProjectControls(toolkit, container, dbc);
        this.createOpenShiftApplicationControls(toolkit, container, dbc);
        this.createDebuggingControls(toolkit, container, dbc);
        return container;
    }

    private void createConnectionContols(Composite parent, DataBindingContext dbc) {
        Label connectionLabel = new Label(parent, 0);
        connectionLabel.setText("Connection:");
        Composite comboHolder = new Composite(parent, 0);
        comboHolder.setLayout((Layout)new FillLayout());
        GridData holderData = GridDataFactory.fillDefaults().grab(true, false).create();
        holderData.widthHint = 300;
        comboHolder.setLayoutData((Object)holderData);
        this.currentConnectionText = new Text(comboHolder, 2052);
        this.currentConnectionText.setEnabled(false);
        this.currentConnectionText.setEditable(false);
    }

    protected void createEclipseProjectControls(FormToolkit toolkit, Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        FormText title = toolkit.createFormText(container, false);
        title.setText("<b>Eclipse Project Source (From)</b>", true, false);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)title);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)toolkit.createSeparator(container, 256));
        this.createProjectControls(container, dbc);
        this.createProjectPathControls(container, dbc);
    }

    private void createProjectControls(Composite parent, DataBindingContext dbc) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText("Eclipse Project: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)projectLabel);
        this.projectText = new Text(parent, 2056);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, true).applyTo((Control)this.projectText);
    }

    private void createProjectPathControls(Composite parent, DataBindingContext dbc) {
        Label sourcePathLabel = new Label(parent, 0);
        sourcePathLabel.setText("Source Path: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)sourcePathLabel);
        this.sourcePathText = new Text(parent, 2056);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).applyTo((Control)this.sourcePathText);
        new Label(parent, 0);
    }

    private void createOpenShiftApplicationControls(FormToolkit toolkit, Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        FormText title = toolkit.createFormText(container, false);
        title.setText("<b>OpenShift Application Destination (To)</b>", true, false);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)title);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)toolkit.createSeparator(container, 256));
        this.createResourceControls(container, dbc);
        this.createPodPathControls(container, dbc);
    }

    private void createPodPathControls(Composite parent, DataBindingContext dbc) {
        Label deployPathLabel = new Label(parent, 0);
        deployPathLabel.setText("Pod Deployment Path: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)deployPathLabel);
        this.deployPathText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.deployPathText);
        this.deployPathModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ServerWorkingCopyPropertyTextCommand(OpenShiftServerEditorSection.this.input.getServer(), "Set Deploy Path", OpenShiftServerEditorSection.this.deployPathText, OpenShiftServerEditorSection.this.deployPathText.getText(), "org.jboss.tools.openshift.PodPath", (ModifyListener)this));
            }
        };
        TextboxDecoratorSupport deployPathDecoration = new TextboxDecoratorSupport(this.deployPathText, value -> {
            if (!(value instanceof String) || StringUtils.isEmpty((Object)value)) {
                return ValidationStatus.cancel((String)"Please provide a path to deploy to on the pod.");
            }
            if (!Path.isValidPosixPath((String)((String)value))) {
                return ValidationStatus.error((String)"Please provide a valid path to deploy to on the pod");
            }
            return Status.OK_STATUS;
        });
        this.deployPathText.addModifyListener((ModifyListener)deployPathDecoration);
    }

    private void createResourceControls(Composite parent, DataBindingContext dbc) {
        this.resourceKindLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.resourceKindLabel);
        this.resourceText = new Text(parent, 2056);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.resourceText);
    }

    private void createDebuggingControls(FormToolkit toolkit, Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(container);
        FormText title = toolkit.createFormText(container, false);
        title.setText("<b>Debugging Settings</b>", true, false);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)title);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)toolkit.createSeparator(container, 256));
        this.createEnableDebuggingControls(toolkit, container, dbc);
        this.createDebuggingPortControls(toolkit, container, dbc);
    }

    private void createEnableDebuggingControls(FormToolkit toolkit, Composite container, DataBindingContext dbc) {
        Label enableDevmodeLabel = new Label(container, 0);
        enableDevmodeLabel.setText("Enable debugging:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)enableDevmodeLabel);
        this.useImageDevmodeKeyButton = toolkit.createButton(container, "use image provided key", 32);
        GridDataFactory.fillDefaults().span(4, 1).align(4, 0x1000000).applyTo((Control)this.useImageDevmodeKeyButton);
        new Label(container, 0);
        Label keyLabel = new Label(container, 0);
        keyLabel.setText("Key:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)keyLabel);
        this.devmodeKeyText = new Text(container, 2048);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).applyTo((Control)this.devmodeKeyText);
        this.devmodeKeyModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ServerWorkingCopyPropertyTextCommand(OpenShiftServerEditorSection.this.input.getServer(), "SetDevmodeKey", OpenShiftServerEditorSection.this.devmodeKeyText, OpenShiftServerEditorSection.this.devmodeKeyText.getText(), "org.jboss.tools.openshift.DevmodeKey", (ModifyListener)this));
            }
        };
        TextboxDecoratorSupport devmodeKeyModifyDecoration = new TextboxDecoratorSupport(this.devmodeKeyText, value -> {
            if (!this.useImageDevmodeKeyButton.getSelection()) {
                return new OpenShiftIdentifierValidator().validate(this.devmodeKeyText.getText());
            }
            return Status.OK_STATUS;
        });
        this.devmodeKeyText.addModifyListener((ModifyListener)devmodeKeyModifyDecoration);
        this.useImageDevmodeKeyListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ToggleDebuggingCommand(OpenShiftServerEditorSection.this.input.getServer(), OpenShiftServerEditorSection.this.useImageDevmodeKeyButton, OpenShiftServerEditorSection.this.devmodeKeyText, (SelectionListener)this, OpenShiftServerEditorSection.this.devmodeKeyModifyListener));
            }
        };
    }

    private void createDebuggingPortControls(FormToolkit toolkit, Composite container, DataBindingContext dbc) {
        Label debugPortLabel = new Label(container, 0);
        debugPortLabel.setText("Debugging Port:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)debugPortLabel);
        this.useImageDebugPortKeyButton = new Button(container, 32);
        this.useImageDebugPortKeyButton.setText("use image provided key and value");
        GridDataFactory.fillDefaults().span(4, 1).align(4, 0x1000000).applyTo((Control)this.useImageDebugPortKeyButton);
        new Label(container, 0);
        Label keyLabel = new Label(container, 0);
        keyLabel.setText("Key:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)keyLabel);
        this.debugPortKeyText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.debugPortKeyText);
        this.debugPortKeyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ServerWorkingCopyPropertyTextCommand(OpenShiftServerEditorSection.this.input.getServer(), "SetDebugPortKey", OpenShiftServerEditorSection.this.debugPortKeyText, OpenShiftServerEditorSection.this.debugPortKeyText.getText(), "org.jboss.tools.openshift.DebugPortKey", (ModifyListener)this));
            }
        };
        TextboxDecoratorSupport debugPortKeyDecoration = new TextboxDecoratorSupport(this.debugPortKeyText, value -> {
            if (!this.useImageDebugPortKeyButton.getSelection()) {
                return new OpenShiftIdentifierValidator().validate(this.debugPortKeyText.getText());
            }
            return Status.OK_STATUS;
        });
        this.debugPortKeyText.addModifyListener((ModifyListener)debugPortKeyDecoration);
        Label portLabel = new Label(container, 0);
        portLabel.setText("Port:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)portLabel);
        this.debugPortText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.debugPortText);
        this.debugPortValListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ServerWorkingCopyPropertyTextCommand(OpenShiftServerEditorSection.this.input.getServer(), "SetDebugPortValue", OpenShiftServerEditorSection.this.debugPortText, OpenShiftServerEditorSection.this.debugPortText.getText(), "org.jboss.tools.openshift.DebugPortValue", (ModifyListener)this));
            }
        };
        TextboxDecoratorSupport debugPortValDecoration = new TextboxDecoratorSupport(this.debugPortText, value -> {
            if (!this.useImageDebugPortKeyButton.getSelection()) {
                return new NumericValidator("integer", Integer::parseInt, true).validate((Object)this.debugPortText.getText());
            }
            return Status.OK_STATUS;
        });
        this.debugPortText.addModifyListener((ModifyListener)debugPortValDecoration);
        this.debugPortKeyValSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenShiftServerEditorSection.this.execute((IUndoableOperation)new ToggleDebugKeyValueCommand(OpenShiftServerEditorSection.this.server, OpenShiftServerEditorSection.this.useImageDebugPortKeyButton, (SelectionListener)this, OpenShiftServerEditorSection.this.debugPortKeyText, OpenShiftServerEditorSection.this.debugPortKeyListener, OpenShiftServerEditorSection.this.debugPortText, OpenShiftServerEditorSection.this.debugPortValListener));
            }
        };
    }

    private void setInitialModel(InitialModel im) {
        this.initialModel = im;
    }

    private void loadResources(final Composite container, DataBindingContext dbc) {
        IServerWorkingCopy server = this.input.getServer();
        Cursor busyCursor = new Cursor((Device)container.getDisplay(), 1);
        NullProgressMonitor chainProgressMonitor = new NullProgressMonitor(){

            public boolean isCanceled() {
                return container.isDisposed();
            }
        };
        new JobChainBuilder((Job)new DisableAllWidgetsJobFixed(true, container, busyCursor, dbc), (IProgressMonitor)chainProgressMonitor).runWhenDone((Job)new LoadResourcesJob(server)).runWhenDone((Job)new DisableAllWidgetsJobFixed(false, container, false, busyCursor, dbc)).runWhenDone((Job)new InitializeWidgetsJob()).schedule();
    }

    private void setupWarningToRestartAdapter(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        final IObservableValue dirtyStatusObservable = DataBindingUtils.createDirtyStatusObservable((IEditorPart)editor);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                if (Boolean.TRUE.equals(dirtyStatusObservable.getValue())) {
                    return ValidationStatus.warning((String)"Changes will only get active once the editor is saved and the adapter restarted.");
                }
                return ValidationStatus.ok();
            }
        });
    }

    private ServerEditor getServerEditor() {
        if (!(this.input instanceof ServerEditorPartInput)) {
            return null;
        }
        ServerResourceCommandManager commandManager = ((ServerEditorPartInput)this.input).getServerCommandManager();
        return commandManager.getServerEditor();
    }

    public IStatus[] getSaveStatus() {
        return new IStatus[]{this.ignoreWarning(this.getFormPresenterStatus())};
    }

    private IStatus getFormPresenterStatus() {
        IStatus stat = this.formPresenterSupport.getCurrentStatus();
        if (stat != null) {
            return stat;
        }
        return Status.OK_STATUS;
    }

    private IStatus ignoreWarning(IStatus status) {
        if (2 == status.getSeverity()) {
            return Status.OK_STATUS;
        }
        return status;
    }

    public void dispose() {
        this.formPresenterSupport.dispose();
        this.dbc.dispose();
    }

    private class DisableAllWidgetsJobFixed
    extends DisableAllWidgetsJob {
        Composite container;
        private DataBindingContext dbc;

        public DisableAllWidgetsJobFixed(boolean disable, Composite container, Cursor cursor, DataBindingContext dbc) {
            super(disable, container, cursor);
            this.dbc = dbc;
        }

        public DisableAllWidgetsJobFixed(boolean disableWidgets, Composite container, boolean disableCursor, Cursor cursor, DataBindingContext dbc) {
            super(disableWidgets, container, disableCursor, cursor);
            this.container = container;
            this.dbc = dbc;
        }

        public void run() {
            if (this.container != null && !this.container.isDisposed()) {
                super.run();
                if (this.dbc != null) {
                    this.dbc.updateTargets();
                }
            }
        }
    }

    private class InitialModel {
        private Connection con;
        private IProject deployProj;
        private String sourcePath;
        private String podPath;
        private IResource openshiftResource;

        public InitialModel(Connection con, IProject deployProj, String sourcePath, String podPath, IResource openshiftResource) {
            this.con = con;
            this.deployProj = deployProj;
            this.sourcePath = sourcePath;
            this.podPath = podPath;
            this.openshiftResource = openshiftResource;
        }
    }

    private class InitializeWidgetsJob
    extends UIJob {
        public InitializeWidgetsJob() {
            super(OpenShiftServerEditorSection.this.getServerEditor().getEditorSite().getShell().getDisplay(), "Initialize Controls");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.initializeWidgetValues();
            this.addListeners();
            return Status.OK_STATUS;
        }

        private void addListeners() {
            OpenShiftServerEditorSection.this.useImageDebugPortKeyButton.addSelectionListener(OpenShiftServerEditorSection.this.debugPortKeyValSelectionListener);
            OpenShiftServerEditorSection.this.deployPathText.addModifyListener(OpenShiftServerEditorSection.this.deployPathModifyListener);
            OpenShiftServerEditorSection.this.devmodeKeyText.addModifyListener(OpenShiftServerEditorSection.this.devmodeKeyModifyListener);
            OpenShiftServerEditorSection.this.useImageDevmodeKeyButton.addSelectionListener((SelectionListener)OpenShiftServerEditorSection.this.useImageDevmodeKeyListener);
            OpenShiftServerEditorSection.this.debugPortText.addModifyListener(OpenShiftServerEditorSection.this.debugPortValListener);
            OpenShiftServerEditorSection.this.debugPortKeyText.addModifyListener(OpenShiftServerEditorSection.this.debugPortKeyListener);
        }

        private String nullSafe(String s) {
            return s == null ? "" : s;
        }

        private void initializeWidgetValues() {
            if (OpenShiftServerEditorSection.this.initialModel.con != null) {
                OpenShiftServerEditorSection.this.currentConnectionText.setText(this.nullSafe(OpenShiftServerEditorSection.this.initialModel.con.toString()));
            }
            if (OpenShiftServerEditorSection.this.initialModel.deployProj != null) {
                OpenShiftServerEditorSection.this.projectText.setText(this.nullSafe(OpenShiftServerEditorSection.this.initialModel.deployProj.getName()));
            }
            if (OpenShiftServerEditorSection.this.initialModel.sourcePath != null) {
                OpenShiftServerEditorSection.this.sourcePathText.setText(OpenShiftServerEditorSection.this.initialModel.sourcePath);
            }
            if (OpenShiftServerEditorSection.this.initialModel.openshiftResource != null) {
                String kind = String.valueOf(this.nullSafe(OpenShiftServerEditorSection.this.initialModel.openshiftResource.getKind())) + ":";
                OpenShiftServerEditorSection.this.resourceKindLabel.setText(kind);
                String namespaceAndName = String.valueOf(this.nullSafe(OpenShiftServerEditorSection.this.initialModel.openshiftResource.getNamespace())) + "/" + this.nullSafe(OpenShiftServerEditorSection.this.initialModel.openshiftResource.getName());
                OpenShiftServerEditorSection.this.resourceText.setText(namespaceAndName);
            } else {
                OpenShiftServerEditorSection.this.resourceKindLabel.setText("Resource: ");
                OpenShiftServerEditorSection.this.resourceText.setText("<not found>");
            }
            if (OpenShiftServerEditorSection.this.initialModel.podPath != null) {
                OpenShiftServerEditorSection.this.deployPathText.setText(OpenShiftServerEditorSection.this.initialModel.podPath);
            }
            String currentKey = OpenShiftServerEditorSection.this.input.getServer().getAttribute("org.jboss.tools.openshift.DebugPortKey", null);
            String currentVal = OpenShiftServerEditorSection.this.input.getServer().getAttribute("org.jboss.tools.openshift.DebugPortValue", null);
            if (StringUtils.isEmpty((String)currentKey) && StringUtils.isEmpty((String)currentVal)) {
                OpenShiftServerEditorSection.this.useImageDebugPortKeyButton.setSelection(true);
                OpenShiftServerEditorSection.this.debugPortKeyText.setText("");
                OpenShiftServerEditorSection.this.debugPortText.setText("");
                OpenShiftServerEditorSection.this.debugPortKeyText.setEnabled(false);
                OpenShiftServerEditorSection.this.debugPortText.setEnabled(false);
            } else {
                OpenShiftServerEditorSection.this.useImageDebugPortKeyButton.setSelection(false);
                OpenShiftServerEditorSection.this.debugPortKeyText.setText(currentKey);
                OpenShiftServerEditorSection.this.debugPortText.setText(currentVal);
                OpenShiftServerEditorSection.this.debugPortKeyText.setEnabled(true);
                OpenShiftServerEditorSection.this.debugPortText.setEnabled(true);
            }
            String devModeCurrentVal = OpenShiftServerEditorSection.this.input.getServer().getAttribute("org.jboss.tools.openshift.DevmodeKey", null);
            if (StringUtils.isEmpty((String)devModeCurrentVal)) {
                OpenShiftServerEditorSection.this.useImageDevmodeKeyButton.setSelection(true);
            } else {
                OpenShiftServerEditorSection.this.useImageDevmodeKeyButton.setSelection(false);
                OpenShiftServerEditorSection.this.devmodeKeyText.setText(devModeCurrentVal);
            }
            OpenShiftServerEditorSection.this.devmodeKeyText.setEnabled(!OpenShiftServerEditorSection.this.useImageDevmodeKeyButton.getSelection());
        }
    }

    private class LoadResourcesJob
    extends Job {
        private IServerWorkingCopy server;

        public LoadResourcesJob(IServerWorkingCopy server) {
            super("Loading OpenShift Server Resources...");
            this.server = server;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject deployProject = OpenShiftServerUtils.getDeployProject((IServerAttributes)this.server);
            Connection con = OpenShiftServerUtils.getConnection((IServerAttributes)this.server);
            String sourcePath = OpenShiftServerUtils.getSourcePath((IServerAttributes)this.server);
            String podPath = OpenShiftServerUtils.getPodPath((IServerAttributes)this.server);
            IResource resource = null;
            if (con != null) {
                resource = OpenShiftServerUtils.getResource((IServerAttributes)this.server, (IProgressMonitor)monitor);
            }
            InitialModel im = new InitialModel(con, deployProject, sourcePath, podPath, resource);
            OpenShiftServerEditorSection.this.setInitialModel(im);
            return Status.OK_STATUS;
        }
    }

    private class TextboxDecoratorSupport
    implements ModifyListener {
        Text t;
        IValidator v;
        ControlDecoration decorator;

        public TextboxDecoratorSupport(Text text, IValidator validator) {
            this.t = text;
            this.v = validator;
            this.decorator = new ControlDecoration((Control)this.t, 0x1000000);
        }

        public void modifyText(ModifyEvent e) {
            IStatus s = this.v.validate((Object)this.t.getText());
            if (!s.isOK()) {
                String imgKey = null;
                if (s.getSeverity() == 4) {
                    imgKey = "DEC_ERROR";
                } else if (s.getSeverity() == 2) {
                    imgKey = "DEC_WARNING";
                }
                if (imgKey != null) {
                    Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(imgKey).getImage();
                    this.decorator.setImage(image);
                    this.decorator.setDescriptionText(s.getMessage());
                    this.decorator.show();
                } else {
                    this.decorator.hide();
                }
            } else {
                this.decorator.hide();
            }
        }
    }

    private static class ToggleDebugKeyValueCommand
    extends ServerCommand {
        private IServerWorkingCopy wc;
        private Button useImageDebugPortKeyButton;
        private SelectionListener toggleListener;
        private Text debugPortKeyText;
        private Text debugPortText;
        private ModifyListener keyModifier;
        private ModifyListener valModifier;
        private boolean preSelected;
        private String preKey;
        private String preVal;

        public ToggleDebugKeyValueCommand(IServerWorkingCopy server, Button useImageDebugPortKeyButton, SelectionListener toggleListener, Text debugPortKeyText, ModifyListener keyModifier, Text debugPortText, ModifyListener valModifier) {
            super(server, "Enable Debugging");
            this.wc = server;
            this.useImageDebugPortKeyButton = useImageDebugPortKeyButton;
            this.toggleListener = toggleListener;
            this.debugPortKeyText = debugPortKeyText;
            this.debugPortText = debugPortText;
            this.keyModifier = keyModifier;
            this.valModifier = valModifier;
            this.preSelected = !useImageDebugPortKeyButton.getSelection();
            this.preKey = debugPortKeyText.getText();
            this.preVal = debugPortText.getText();
        }

        public void execute() {
            this.useImageDebugPortKeyButton.removeSelectionListener(this.toggleListener);
            this.debugPortKeyText.removeModifyListener(this.keyModifier);
            this.debugPortText.removeModifyListener(this.valModifier);
            if (this.useImageDebugPortKeyButton.getSelection()) {
                this.wc.setAttribute("org.jboss.tools.openshift.DebugPortKey", null);
                this.wc.setAttribute("org.jboss.tools.openshift.DebugPortValue", null);
            } else {
                this.wc.setAttribute("org.jboss.tools.openshift.DebugPortKey", "");
                this.wc.setAttribute("org.jboss.tools.openshift.DebugPortValue", "");
            }
            this.debugPortKeyText.setEnabled(this.preSelected);
            this.debugPortText.setEnabled(this.preSelected);
            this.debugPortKeyText.setText("");
            this.debugPortText.setText("");
            this.useImageDebugPortKeyButton.addSelectionListener(this.toggleListener);
            this.debugPortKeyText.addModifyListener(this.keyModifier);
            this.debugPortText.addModifyListener(this.valModifier);
        }

        public void undo() {
            this.useImageDebugPortKeyButton.removeSelectionListener(this.toggleListener);
            this.debugPortKeyText.removeModifyListener(this.keyModifier);
            this.debugPortText.removeModifyListener(this.valModifier);
            this.wc.setAttribute("org.jboss.tools.openshift.DebugPortKey", this.preKey);
            this.wc.setAttribute("org.jboss.tools.openshift.DebugPortValue", this.preVal);
            this.debugPortKeyText.setEnabled(!this.preSelected);
            this.debugPortText.setEnabled(!this.preSelected);
            this.useImageDebugPortKeyButton.setSelection(this.preSelected);
            this.debugPortKeyText.setText(this.preKey);
            this.debugPortText.setText(this.preVal);
            this.useImageDebugPortKeyButton.addSelectionListener(this.toggleListener);
            this.debugPortKeyText.addModifyListener(this.keyModifier);
            this.debugPortText.addModifyListener(this.valModifier);
        }
    }

    private static class ToggleDebuggingCommand
    extends ServerCommand {
        private IServerWorkingCopy wc;
        private Button useImageDevmodeKeyButton;
        private Text devmodeKeyText;
        private SelectionListener toggleListener;
        private ModifyListener textListener;
        private boolean preSelected;
        private String preText;

        public ToggleDebuggingCommand(IServerWorkingCopy server, Button useImageDevmodeKeyButton, Text devmodeKeyText, SelectionListener toggleListener, ModifyListener textListener) {
            super(server, "Enable Debugging");
            this.wc = server;
            this.useImageDevmodeKeyButton = useImageDevmodeKeyButton;
            this.devmodeKeyText = devmodeKeyText;
            this.preSelected = !useImageDevmodeKeyButton.getSelection();
            this.preText = devmodeKeyText.getText();
            this.toggleListener = toggleListener;
            this.textListener = textListener;
        }

        public void execute() {
            this.useImageDevmodeKeyButton.removeSelectionListener(this.toggleListener);
            this.devmodeKeyText.removeModifyListener(this.textListener);
            if (this.useImageDevmodeKeyButton.getSelection()) {
                this.wc.setAttribute("org.jboss.tools.openshift.DevmodeKey", null);
            } else {
                this.wc.setAttribute("org.jboss.tools.openshift.DevmodeKey", "");
            }
            this.devmodeKeyText.setEnabled(this.preSelected);
            this.devmodeKeyText.setText("");
            this.useImageDevmodeKeyButton.addSelectionListener(this.toggleListener);
            this.devmodeKeyText.addModifyListener(this.textListener);
        }

        public void undo() {
            this.useImageDevmodeKeyButton.removeSelectionListener(this.toggleListener);
            this.devmodeKeyText.removeModifyListener(this.textListener);
            this.wc.setAttribute("org.jboss.tools.openshift.DevmodeKey", this.preText);
            this.devmodeKeyText.setEnabled(!this.preSelected);
            this.useImageDevmodeKeyButton.setSelection(this.preSelected);
            this.devmodeKeyText.setText(this.preText);
            this.useImageDevmodeKeyButton.addSelectionListener(this.toggleListener);
            this.devmodeKeyText.addModifyListener(this.textListener);
        }
    }
}

