/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.route.IRoute;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIMessages;
import org.jboss.tools.openshift.internal.common.ui.SelectExistingProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.SelectProjectComponentBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.DisableableMultiValitdator;
import org.jboss.tools.openshift.internal.common.ui.databinding.FormPresenterSupport;
import org.jboss.tools.openshift.internal.common.ui.databinding.NumericValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DialogAdvancedPart;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.comparators.ProjectViewerComparator;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;
import org.jboss.tools.openshift.internal.ui.server.ResourceDetailViews;
import org.jboss.tools.openshift.internal.ui.server.ResourcesViewLabelProvider;
import org.jboss.tools.openshift.internal.ui.server.ServerResourceViewModel;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsWizardPageModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewerFilter;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.validator.OpenShiftIdentifierValidator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizard;

public class ServerSettingsWizardPage
extends AbstractOpenShiftWizardPage
implements DeploymentTypeUIUtil.ICompletable {
    private static final String DOWNLOAD_LINK_TEXT = "download";
    private static final int RESOURCE_PANEL_WIDTH = 800;
    private static final int RESOURCE_TREE_WIDTH = 400;
    private static final int RESOURCE_TREE_HEIGHT = 120;
    protected ServerSettingsWizardPageModel model;
    protected boolean needsLoadingResources = true;
    protected boolean isLoadingResources = false;
    protected Control uiHook = null;

    public ServerSettingsWizardPage(IWizard wizard, IServerWorkingCopy server, Connection connection, IProject deployProject) {
        this(wizard, server, connection, null, null, deployProject);
    }

    protected ServerSettingsWizardPage(IWizard wizard, IServerWorkingCopy server, Connection connection, IResource resource, IRoute route) {
        this(wizard, server, connection, resource, route, null);
    }

    protected ServerSettingsWizardPage(IWizard wizard, IServerWorkingCopy server, Connection connection, IResource resource, IRoute route, IProject deployProject) {
        super("Server Settings", "Create an OpenShift 3 Server Adapter by selecting the project, resource and folders used for file synchronization.", "Create an OpenShift 3 Server Adapter", wizard);
        this.model = new ServerSettingsWizardPageModel(resource, route, deployProject, connection, server, OCBinary.getInstance().getStatus((IConnection)connection, (IProgressMonitor)new NullProgressMonitor()));
    }

    ServerSettingsWizardPageModel getModel() {
        return this.model;
    }

    void updateServer() {
        this.model.updateServer();
    }

    public boolean isNeedsLoadingResources() {
        return this.needsLoadingResources;
    }

    public boolean isLoadingResources() {
        return this.isLoadingResources;
    }

    public void setComplete(boolean complete) {
        this.setPageComplete(complete);
    }

    protected void doCreateControls(final Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).applyTo(parent);
        this.createControls(parent, this.model, dbc);
        this.isLoadingResources = false;
        new FormPresenterSupport(new FormPresenterSupport.IFormPresenter(){

            public void setMessage(String message, int type) {
                if (ServerSettingsWizardPage.this.getContainer() != null) {
                    ServerSettingsWizardPage.this.setMessage(message, type);
                }
            }

            public void setComplete(boolean complete) {
                if (ServerSettingsWizardPage.this.getContainer() != null) {
                    ServerSettingsWizardPage.this.setComplete(complete);
                }
            }

            public Control getControl() {
                return parent;
            }
        }, dbc);
        this.setComplete(true);
        this.loadResources(this.getContainer());
    }

    private void loadResources(IWizardContainer container) {
        try {
            WizardUtils.runInWizard((Job)new Job("Loading projects and services..."){

                protected IStatus run(IProgressMonitor monitor) {
                    ServerSettingsWizardPage.this.model.loadResources();
                    ServerSettingsWizardPage.this.needsLoadingResources = false;
                    return Status.OK_STATUS;
                }
            }, (IWizardContainer)container);
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    void setDeploymentProject(IProject project) {
        if (project != null) {
            this.model.setDeployProject(project);
        }
    }

    private Composite createControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        this.createOCWarningControls(container, model, dbc);
        this.createEclipseProjectSourceControls(container, model, dbc);
        this.createOpenShiftDestinationControls(container, model, dbc);
        this.createAdvancedGroup(container, dbc);
        this.uiHook = container;
        return container;
    }

    private void createOCWarningControls(Composite container, final ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Composite composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.visible().observe((Widget)composite)).to(BeanProperties.value((String)"OCBinaryStatus").observe((Object)model)).converting((IConverter)new Converter(IStatus.class, Boolean.class){

            public Object convert(Object fromObject) {
                return !((IStatus)fromObject).isOK();
            }
        })).in(dbc);
        Label label = new Label(composite, 0);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.image().observe((Widget)label)).to(BeanProperties.value((String)"OCBinaryStatus").observe((Object)model)).converting((IConverter)new Converter(IStatus.class, Image.class){

            public Object convert(Object fromObject) {
                switch (((IStatus)fromObject).getSeverity()) {
                    case 2: {
                        return JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    }
                    case 4: {
                        return JFaceResources.getImage((String)"dialog_message_error_image");
                    }
                }
                return null;
            }
        })).in(dbc);
        Link link = new Link(composite, 64);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text().observe((Widget)link)).to(BeanProperties.value((String)"OCBinaryStatus").observe((Object)model)).converting((IConverter)new Converter(IStatus.class, String.class){

            public Object convert(Object fromObject) {
                return ((IStatus)fromObject).getMessage();
            }
        })).in(dbc);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerSettingsWizardPage.DOWNLOAD_LINK_TEXT.equals(e.text)) {
                    new BrowserUtility().checkedCreateExternalBrowser("https://github.com/openshift/origin/blob/master/CONTRIBUTING.adoc#download-from-github", "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
                } else {
                    int rc = PreferencesUtil.createPreferenceDialogOn((Shell)ServerSettingsWizardPage.this.getShell(), (String)"org.jboss.tools.openshift.ui.preferences.OpenShiftPreferencePage", (String[])new String[]{"org.jboss.tools.openshift.ui.preferences.OpenShiftPreferencePage"}, null).open();
                    if (rc == 0) {
                        new Job("Checking oc binary"){

                            protected IStatus run(IProgressMonitor monitor) {
                                IStatus stat = OCBinary.getInstance().getStatus((IConnection)model.getConnection(), monitor);
                                model.setOCBinaryStatus(stat);
                                return stat;
                            }
                        }.schedule();
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().hint(600, -1).applyTo((Control)link);
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                IObservableValue observable = BeanProperties.value((String)"OCBinaryStatus").observe((Object)model);
                Status status = (Status)observable.getValue();
                switch (status.getSeverity()) {
                    case 4: {
                        return OpenShiftUIActivator.statusFactory().errorStatus(OpenShiftUIMessages.OCBinaryErrorMessage);
                    }
                    case 2: {
                        return OpenShiftUIActivator.statusFactory().warningStatus(OpenShiftUIMessages.OCBinaryWarningMessage);
                    }
                }
                return status;
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
    }

    private void createEclipseProjectSourceControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Group container = new Group(parent, 0);
        container.setText("Eclipse Project Source (From)");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 10).spacing(4, 4).applyTo((Composite)container);
        this.createProjectControls((Composite)container, model, dbc);
        this.createSourcePathControls((Composite)container, model, dbc);
    }

    private void createProjectControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        IObservableValue eclipseProjectObservable = BeanProperties.value((String)"deployProject").observe((Object)model);
        new SelectProjectComponentBuilder().setTextLabel("Eclipse Project: ").setEclipseProjectObservable(eclipseProjectObservable).setSelectionListener(this.onBrowseProjects(model, parent.getShell())).build(parent, dbc);
        Button importButton = new Button(parent, 8);
        importButton.setText(OpenShiftCommonUIMessages.ImportButtonLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)importButton);
        UIUtils.setDefaultButtonWidth((Button)importButton);
        importButton.addSelectionListener(this.onImportProject(model, parent.getShell()));
    }

    private IDoubleClickListener onDoubleClickService() {
        return event -> {
            if (this.getWizard().canFinish()) {
                Button finishButton = this.getShell().getDefaultButton();
                UIUtils.clickButton((Button)finishButton);
            }
        };
    }

    private SelectionListener onBrowseProjects(final ServerSettingsWizardPageModel model, final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedProject;
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog("Select a project to deploy", shell);
                if (model.getDeployProject() != null) {
                    dialog.setInitialSelections(new Object[]{model.getDeployProject()});
                }
                if (dialog.open() == 0 && (selectedProject = dialog.getFirstResult()) instanceof IProject) {
                    model.setDeployProject((IProject)selectedProject);
                }
            }
        };
    }

    private SelectionListener onImportProject(final ServerSettingsWizardPageModel model, final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (model.getResource() == null) {
                    MessageDialog.openWarning((Shell)shell, (String)"No Build Configurations found", (String)"A build config is used to import a project to Eclipse");
                    return;
                }
                HashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> projectsAndBuildConfigs = new HashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>>();
                projectsAndBuildConfigs.put(model.getResource().getProject(), Collections.emptyList());
                ImportApplicationWizard wizard = new ImportApplicationWizard(projectsAndBuildConfigs);
                boolean done = WizardUtils.openWizardDialog((IWorkbenchWizard)wizard, (Shell)shell);
                if (done) {
                    model.setDeployProject(ResourcesPlugin.getWorkspace().getRoot().getProject(wizard.getModel().getRepoName()));
                }
            }
        };
    }

    private void createSourcePathControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Label sourcePathLabel = new Label(parent, 0);
        sourcePathLabel.setText("Source Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sourcePathLabel);
        Text sourcePathText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sourcePathText);
        Binding sourcePathBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)sourcePathText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                String path = (String)value;
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)path)) {
                    return ValidationStatus.cancel((String)"Please provide a local path to deploy from.");
                }
                String provideValidPathMessage = "Please provide a valid local path to deploy from.";
                try {
                    path = VariablesHelper.replaceVariables((String)path);
                }
                catch (OpenShiftCoreException e) {
                    String message = StringUtils.substringAfter((String)e.getMessage(), (String)"Exception:");
                    return ValidationStatus.error((String)(String.valueOf(provideValidPathMessage) + "\nError: " + message));
                }
                if (!this.isReadableFile(path)) {
                    return ValidationStatus.error((String)provideValidPathMessage);
                }
                return ValidationStatus.ok();
            }

            private boolean isReadableFile(String path) {
                return new File(path).canRead();
            }
        })).to(BeanProperties.value((String)"sourcePath").observe((Object)model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)sourcePathBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button browseSourceButton = new Button(parent, 8);
        browseSourceButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(10, -1).applyTo((Control)browseSourceButton);
        browseSourceButton.addSelectionListener((SelectionListener)this.onBrowseSource(browseSourceButton.getShell()));
        Button browseWorkspaceSourceButton = new Button(parent, 8);
        browseWorkspaceSourceButton.setText("Workspace...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)browseWorkspaceSourceButton);
        browseWorkspaceSourceButton.addSelectionListener((SelectionListener)this.onBrowseWorkspace(browseWorkspaceSourceButton.getShell()));
        UIUtils.setEqualButtonWidth((Button[])new Button[]{browseSourceButton, browseWorkspaceSourceButton});
    }

    private SelectionAdapter onBrowseSource(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setText("Choose the source path to sync");
                String sourcePath = VariablesHelper.replaceVariables((String)ServerSettingsWizardPage.this.model.getSourcePath(), (boolean)true);
                dialog.setFilterPath(sourcePath);
                String filepath = dialog.open();
                if (!org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)filepath)) {
                    ServerSettingsWizardPage.this.model.setSourcePath(filepath);
                }
            }
        };
    }

    private SelectionAdapter onBrowseWorkspace(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourcePath = ServerSettingsWizardPage.this.getWorkspaceRelativePath(ServerSettingsWizardPage.this.model.getSourcePath());
                ElementTreeSelectionDialog dialog = ServerSettingsWizardPage.this.createWorkspaceFolderDialog(shell, sourcePath);
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IContainer) {
                    String path = ((IContainer)dialog.getFirstResult()).getFullPath().toString();
                    String folderPath = VariablesHelper.addWorkspacePrefix((String)path);
                    ServerSettingsWizardPage.this.model.setSourcePath(folderPath);
                }
            }
        };
    }

    private String getWorkspaceRelativePath(String sourcePath) {
        if (StringUtils.isBlank((String)sourcePath) || sourcePath.contains("{")) {
            return sourcePath;
        }
        Path absolutePath = new Path(sourcePath);
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)absolutePath);
        if (container != null) {
            return container.getFullPath().toString();
        }
        return null;
    }

    private ElementTreeSelectionDialog createWorkspaceFolderDialog(Shell shell, String selectedFile) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select a workspace folder");
        dialog.setMessage("Select a workspace folder to deploy");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IContainer)) {
                    return false;
                }
                IContainer container = (IContainer)element;
                return container.isAccessible() && !ProjectUtils.isInternalPde((String)container.getName()) && !ProjectUtils.isInternalRSE((String)container.getName());
            }
        });
        dialog.setAllowMultiple(false);
        IProject res = this.model.getDeployProject();
        if (StringUtils.isNotBlank((String)selectedFile)) {
            String path = VariablesHelper.getWorkspacePath((String)selectedFile);
            org.eclipse.core.resources.IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (member != null) {
                res = member;
            }
        }
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        return dialog;
    }

    private void createOpenShiftDestinationControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Group container = new Group(parent, 0);
        container.setText("OpenShift Application Destination (To)");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)container);
        this.createResourceControls((Composite)container, model, dbc);
        this.createResourcePathControls((Composite)container, model, dbc);
    }

    private void createResourceControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        SashForm resourceControlsContainer = new SashForm(parent, 256);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(800, -1).applyTo((Control)resourceControlsContainer);
        IViewerObservableValue selectedResourceTreeItem = this.createResourceTree(model, resourceControlsContainer, dbc);
        this.createResourceDetails(selectedResourceTreeItem, (Composite)resourceControlsContainer, dbc);
        resourceControlsContainer.setWeights(new int[]{1, 2});
    }

    private void createResourceDetails(IViewerObservableValue selectedResourceTreeItem, Composite parent, DataBindingContext dbc) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        ExpandableComposite expandable = new ExpandableComposite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)expandable);
        expandable.setText("Resource Details");
        expandable.setExpanded(true);
        expandable.setLayout((Layout)new FillLayout());
        Composite detailsContainer = new Composite((Composite)expandable, 0);
        expandable.setClient((Control)detailsContainer);
        expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ServerSettingsWizardPage.this.getControl().update();
                ((Composite)ServerSettingsWizardPage.this.getControl()).layout(true);
            }
        });
        WritableValue selectedResource = new WritableValue();
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedResourceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter())).to((IObservableValue)selectedResource).notUpdatingParticipant()).in(dbc);
        new ResourceDetailViews((IObservableValue)selectedResource, detailsContainer, dbc).createControls();
    }

    private IViewerObservableValue createResourceTree(ServerSettingsWizardPageModel model, SashForm resourceControlsContainer, DataBindingContext dbc) {
        Composite resourceTreeContainer = new Composite((Composite)resourceControlsContainer, 0);
        GridLayoutFactory.fillDefaults().applyTo(resourceTreeContainer);
        Text selectorText = UIUtils.createSearchText((Composite)resourceTreeContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)selectorText);
        TreeViewer resourcesViewer = this.createResourcesTreeViewer(resourceTreeContainer, model, selectorText);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 120).applyTo(resourcesViewer.getControl());
        resourcesViewer.addDoubleClickListener(this.onDoubleClickService());
        IObservableList resourceItemsObservable = BeanProperties.list((String)"resourceItems").observe((Object)model);
        DataBindingUtils.addDisposableListChangeListener(this.onResourceItemsChanged(resourcesViewer), (IObservableList)resourceItemsObservable, (Control)resourcesViewer.getTree());
        selectorText.addModifyListener(this.onFilterTextModified(resourcesViewer));
        IViewerObservableValue selectedResourceTreeItem = ViewerProperties.singleSelection().observe((Viewer)resourcesViewer);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedResourceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter(IResource.class))).validatingAfterConvert(value -> {
            if (value instanceof IResource && OpenShiftServerUtils.isAllowedForServerAdapter((IResource)((IResource)value))) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.cancel((String)"Please select a resource that this adapter will be bound to.");
        })).to(BeanProperties.value((String)"resource").observe((Object)model)).converting((IConverter)new Model2ObservableTreeItemConverter(new ServerResourceViewModel.ResourceTreeItemsFactory()))).in(dbc);
        return selectedResourceTreeItem;
    }

    private void createResourcePathControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(container);
        Button useInferredPodPathButton = new Button(container, 32);
        useInferredPodPathButton.setText("&Use inferred Pod Deployment Path");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).applyTo((Control)useInferredPodPathButton);
        ISWTObservableValue useInferredPodPathObservable = WidgetProperties.selection().observe((Widget)useInferredPodPathButton);
        ValueBindingBuilder.bind((IObservableValue)useInferredPodPathObservable).to(BeanProperties.value((String)"useInferredPodPath").observe((Object)model)).in(dbc);
        Label podPathLabel = new Label(container, 0);
        podPathLabel.setText("Pod Deployment Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)podPathLabel);
        Text podPathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)podPathText);
        ISWTObservableValue podPathObservable = WidgetProperties.text((int)24).observe((Widget)podPathText);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)podPathText)).notUpdatingParticipant()).to((IObservableValue)useInferredPodPathObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)podPathLabel)).notUpdatingParticipant()).to((IObservableValue)useInferredPodPathObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)podPathObservable).to(BeanProperties.value((String)"podPath").observe((Object)model)).in(dbc);
        PodPathValidator podPathValidator = new PodPathValidator((IObservableValue<Boolean>)useInferredPodPathObservable, (IObservableValue<String>)podPathObservable);
        ControlDecorationSupport.create((ValidationStatusProvider)podPathValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        dbc.addValidationStatusProvider((ValidationStatusProvider)podPathValidator);
    }

    private void createAdvancedGroup(Composite parent, final DataBindingContext dbc) {
        DialogAdvancedPart advancedPart = new DialogAdvancedPart(){

            protected void createAdvancedContent(Composite advancedComposite) {
                ServerSettingsWizardPage.this.createDebuggingSettingsControls(advancedComposite, ServerSettingsWizardPage.this.model, dbc);
                ServerSettingsWizardPage.this.createRouteControls(advancedComposite, ServerSettingsWizardPage.this.model, dbc);
            }

            protected GridLayoutFactory adjustAdvancedCompositeLayout(GridLayoutFactory gridLayoutFactory) {
                return gridLayoutFactory.numColumns(1).margins(0, 0);
            }
        };
        advancedPart.createAdvancedGroup(parent, 1);
    }

    private void createDebuggingSettingsControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Group container = new Group(parent, 0);
        container.setText("Debugging Settings");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(5).margins(10, 10).applyTo((Composite)container);
        this.createEnableDebuggingControls((Composite)container, model, dbc);
        this.createDebuggingPortControls((Composite)container, model, dbc);
    }

    private void createEnableDebuggingControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Label enableDevmodeLabel = new Label(parent, 0);
        enableDevmodeLabel.setText("Enable debugging:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)enableDevmodeLabel);
        Button useImageDevmodeKey = new Button(parent, 32);
        useImageDevmodeKey.setText("use image provided key");
        GridDataFactory.fillDefaults().span(4, 1).align(4, 0x1000000).applyTo((Control)useImageDevmodeKey);
        IObservableValue useImageDevmodeKeyObservable = BeanProperties.value((String)"useImageDevmodeKey").observe((Object)model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)useImageDevmodeKey)).to(useImageDevmodeKeyObservable).in(dbc);
        new Label(parent, 0);
        Label keyLabel = new Label(parent, 0);
        keyLabel.setText("Key:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)keyLabel);
        Text devmodeKeyText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)devmodeKeyText);
        ISWTObservableValue devmodeKeyObservable = WidgetProperties.text((int)24).observe((Widget)devmodeKeyText);
        ValueBindingBuilder.bind((IObservableValue)devmodeKeyObservable).to(BeanProperties.value((String)"devmodeKey").observe((Object)model)).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)devmodeKeyText)).notUpdating(useImageDevmodeKeyObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        DisableableMultiValitdator devmodeKeyValidator = new DisableableMultiValitdator(useImageDevmodeKeyObservable, (IObservableValue)devmodeKeyObservable, (IValidator)new OpenShiftIdentifierValidator());
        dbc.addValidationStatusProvider((ValidationStatusProvider)devmodeKeyValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)devmodeKeyValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private void createDebuggingPortControls(Composite parent, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Label debugPortLabel = new Label(parent, 0);
        debugPortLabel.setText("Debugging Port:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)debugPortLabel);
        Button useImageDebugPortKeyButton = new Button(parent, 32);
        useImageDebugPortKeyButton.setText("use image provided key and value");
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).applyTo((Control)useImageDebugPortKeyButton);
        IObservableValue useImageDebugPortKey = BeanProperties.value((String)"useImageDebugPortKey").observe((Object)model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)useImageDebugPortKeyButton)).to(useImageDebugPortKey).in(dbc);
        new Label(parent, 0);
        new Label(parent, 0);
        Label keyLabel = new Label(parent, 0);
        keyLabel.setText("Key:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)keyLabel);
        Text debugPortKeyText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)debugPortKeyText);
        ISWTObservableValue debugPortKeyTextObservable = WidgetProperties.text((int)24).observe((Widget)debugPortKeyText);
        ValueBindingBuilder.bind((IObservableValue)debugPortKeyTextObservable).to(BeanProperties.value((String)"debugPortKey").observe((Object)model)).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)debugPortKeyText)).notUpdating(useImageDebugPortKey).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        DisableableMultiValitdator debugPortKeyValidator = new DisableableMultiValitdator(useImageDebugPortKey, (IObservableValue)debugPortKeyTextObservable, (IValidator)new OpenShiftIdentifierValidator());
        dbc.addValidationStatusProvider((ValidationStatusProvider)debugPortKeyValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)debugPortKeyValidator, (int)16512, (Composite)parent, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        IObservableValue useImageDebugPortValue = BeanProperties.value((String)"useImageDebugPortValue").observe((Object)model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)useImageDebugPortKeyButton)).to(useImageDebugPortValue).in(dbc);
        Label portLabel = new Label(parent, 0);
        portLabel.setText("Port:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)portLabel);
        Text debugPortText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)debugPortText);
        ISWTObservableValue debugPortValueObservable = WidgetProperties.text((int)24).observe((Widget)debugPortText);
        ValueBindingBuilder.bind((IObservableValue)debugPortValueObservable).to(BeanProperties.value((String)"debugPortValue").observe((Object)model)).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)debugPortText)).notUpdating(useImageDebugPortValue).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        DisableableMultiValitdator debugPortValueValidator = new DisableableMultiValitdator(useImageDebugPortValue, (IObservableValue)debugPortValueObservable, (IValidator)new NumericValidator("integer", Integer::parseInt, true));
        dbc.addValidationStatusProvider((ValidationStatusProvider)debugPortValueValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)debugPortValueValidator, (int)16512, (Composite)parent, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private void createRouteControls(Composite container, ServerSettingsWizardPageModel model, DataBindingContext dbc) {
        Group routeGroup = new Group(container, 0);
        routeGroup.setText("Route");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)routeGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)routeGroup);
        Composite routeContainer = new Composite((Composite)routeGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)routeContainer);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).applyTo(routeContainer);
        Button promptRouteButton = new Button(routeContainer, 32);
        promptRouteButton.setSelection(true);
        promptRouteButton.setText("Prompt for route when multiple routes available to show in browser");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)promptRouteButton);
        Label routeLabel = new Label(routeContainer, 0);
        routeLabel.setText("Use Route: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)routeLabel);
        ComboViewer routesViewer = new ComboViewer(routeContainer);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 0x1000000).grab(true, false).applyTo(routesViewer.getControl());
        routesViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        routesViewer.setLabelProvider((IBaseLabelProvider)new SelectRouteDialog.RouteLabelProvider());
        routesViewer.setInput((Object)BeanProperties.list((String)"routes").observe((Object)model));
        IViewerObservableValue selectedRouteObservable = ViewerProperties.singleSelection().observe((Viewer)routesViewer);
        ValueBindingBuilder.bind((IObservableValue)selectedRouteObservable).to(BeanProperties.value((String)"route").observe((Object)model)).in(dbc);
        ISWTObservableValue isSelectDefaultRouteObservable = WidgetProperties.selection().observe((Widget)promptRouteButton);
        IObservableValue selectDefaultRouteModelObservable = BeanProperties.value((String)"selectDefaultRoute").observe((Object)model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)isSelectDefaultRouteObservable).converting((IConverter)new InvertingBooleanConverter())).to(selectDefaultRouteModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)routesViewer.getControl())).notUpdating(selectDefaultRouteModelObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)routeLabel)).notUpdating(selectDefaultRouteModelObservable).in(dbc);
        RouteValidator routeValidator = new RouteValidator((IObservableValue<Boolean>)isSelectDefaultRouteObservable, (IObservableValue<IResource>)selectedRouteObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)routeValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)routeValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private IListChangeListener<ObservableTreeItem> onResourceItemsChanged(TreeViewer resourcesViewer) {
        return event -> resourcesViewer.expandAll();
    }

    private TreeViewer createResourcesTreeViewer(Composite parent, ServerSettingsWizardPageModel model, Text selectorText) {
        TreeViewer applicationTemplatesViewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"resourceItems"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        applicationTemplatesViewer.setContentProvider((IContentProvider)contentProvider);
        applicationTemplatesViewer.setLabelProvider((IBaseLabelProvider)new ResourcesViewLabelProvider());
        applicationTemplatesViewer.addFilter((ViewerFilter)new ServiceViewerFilter(selectorText));
        applicationTemplatesViewer.setComparator(ProjectViewerComparator.createProjectTreeSorter());
        applicationTemplatesViewer.setAutoExpandLevel(-1);
        applicationTemplatesViewer.setInput((Object)model);
        return applicationTemplatesViewer;
    }

    protected ModifyListener onFilterTextModified(TreeViewer applicationTemplatesViewer) {
        return event -> {
            applicationTemplatesViewer.refresh();
            applicationTemplatesViewer.expandAll();
        };
    }

    public void dispose() {
        super.dispose();
        this.uiHook = null;
        this.model.dispose();
    }

    public boolean isPageComplete() {
        return !this.isLoadingResources && this.uiHook != null && !this.uiHook.isDisposed() && !this.needsLoadingResources && this.model != null && this.model.getResource() != null && super.isPageComplete();
    }

    public IServer saveServer(IProgressMonitor monitor) throws CoreException {
        this.model.updateServer();
        return this.model.saveServer(monitor);
    }

    private static class PodPathValidator
    extends MultiValidator {
        private IObservableValue<Boolean> useDefaultPodPath;
        private IObservableValue<String> podPath;

        public PodPathValidator(IObservableValue<Boolean> useDefaultPodPath, IObservableValue<String> podPath) {
            this.useDefaultPodPath = useDefaultPodPath;
            this.podPath = podPath;
        }

        protected IStatus validate() {
            if (BooleanUtils.isFalse((Boolean)((Boolean)this.useDefaultPodPath.getValue()))) {
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)((String)this.podPath.getValue()))) {
                    return ValidationStatus.cancel((String)"Please provide a path to deploy to on the pod.");
                }
                if (!Path.isValidPosixPath((String)((String)this.podPath.getValue()))) {
                    return ValidationStatus.error((String)"You have to choose a path on the pod that route that will be used for this server adapter.");
                }
            }
            return ValidationStatus.ok();
        }
    }

    class RouteValidator
    extends MultiValidator {
        private IObservableValue<Boolean> useDefaultRoute;
        private IObservableValue<IResource> selectedRoute;

        public RouteValidator(IObservableValue<Boolean> useDefaultRoute, IObservableValue<IResource> selectedRoute) {
            this.useDefaultRoute = useDefaultRoute;
            this.selectedRoute = selectedRoute;
        }

        protected IStatus validate() {
            if (BooleanUtils.isFalse((Boolean)((Boolean)this.useDefaultRoute.getValue())) && this.selectedRoute.getValue() == null) {
                return ValidationStatus.cancel((String)"You have to choose a route that will be used for this server adapter.");
            }
            return ValidationStatus.ok();
        }
    }
}

